/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_632;
import net.minecraft.class_8779;
import net.minecraft.class_8781;
import net.minecraft.class_8824;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.mixin.client.ClientAdvancementManagerAccessor;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;

public class AdvancementCondition
implements ModuleCondition {
    public static Codec<AdvancementCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("advancement").forGetter(condition -> condition.advancement), (App)class_8824.field_46597.optionalFieldOf("error", (Object)class_2561.method_43470((String)"Unavailable.")).forGetter(condition -> condition.error)).apply((Applicative)instance, AdvancementCondition::new));
    public class_2960 advancement;
    public class_2561 error;

    public AdvancementCondition(class_2960 perms, class_2561 error) {
        this.advancement = perms;
        this.error = error;
    }

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        Optional<class_1657> playerOptional = conditionContext.getContext(ConditionManager.PLAYER_CONTEXT);
        if (playerOptional.isPresent()) {
            class_8779 advancement1;
            class_1657 player = playerOptional.get();
            List<class_2561> reasons = conditionContext.failReasons;
            if (this.advancement != null && (advancement1 = this.getAdvancement(this.advancement)) != null) {
                return AdvancementCondition.hasAdvancement(advancement1, player);
            }
            reasons.add(this.error);
        }
        return false;
    }

    public static boolean hasAdvancement(class_8779 advancement, class_1657 player) {
        if (Environment.isClient()) {
            return AdvancementCondition.hasAdvancementClient(advancement, player);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            return serverPlayerEntity.method_14236().method_12882(advancement).method_740();
        }
        return false;
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public static boolean hasAdvancementClient(class_8779 advancement, class_1657 player) {
        if (class_310.method_1551() != null && class_310.method_1551().method_1562() != null) {
            class_632 manager = class_310.method_1551().method_1562().method_2869();
            Map<class_8779, class_167> map = ((ClientAdvancementManagerAccessor)manager).getProgress();
            Optional<class_8779> optional = map.keySet().stream().filter(advancement1 -> advancement.comp_1919().equals((Object)advancement1.comp_1919())).findFirst();
            return optional.isPresent() && map.get(optional.get()).method_740();
        }
        return false;
    }

    public class_8779 getAdvancement(class_2960 identifier) {
        if (Environment.isClient()) {
            return this.getAdvancementClient(identifier);
        }
        if (Miapi.server != null) {
            return Miapi.server.method_3851().method_12896(identifier);
        }
        return null;
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public class_8779 getAdvancementClient(class_2960 identifier) {
        class_8781 node;
        if (class_310.method_1551().method_1562() != null && (node = class_310.method_1551().method_1562().method_2869().method_53814().method_716(identifier)) != null) {
            return node.method_53649();
        }
        return null;
    }
}

