/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.skins;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.edit_options.skins.Skin;
import smartin.miapi.modules.edit_options.skins.SkinTab;
import smartin.miapi.modules.edit_options.skins.gui.SkinGui;

public class SkinOptions
implements EditOption {
    public static Map<class_2960, Map<String, Skin>> skins = new HashMap<class_2960, Map<String, Skin>>();
    public static Map<String, SkinTab> tabMap = new HashMap<String, SkinTab>();
    public static SkinTab defaultTab = new SkinTab();

    public SkinOptions() {
        defaultTab = SkinTab.fromJson(null);
        PropertyResolver.register(Miapi.id("skin"), (moduleInstance, oldMap) -> {
            Optional<Skin> foundSkin;
            if (moduleInstance != null && (foundSkin = Skin.getSkin(moduleInstance)).isPresent()) {
                String[] parts = foundSkin.get().path.split("/");
                oldMap = foundSkin.get().propertyHolder.applyHolder(oldMap, Optional.of(class_2561.method_43469((String)"miapi.property.source.skin", (Object[])new Object[]{class_2561.method_43471((String)("miapi.skin." + foundSkin.get().modID + ".name." + parts[parts.length - 1]))})));
            }
            return oldMap;
        }, List.of(Miapi.id("synergy")));
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            int size = 0;
            for (Map<String, Skin> skinMap : skins.values()) {
                size += skinMap.size();
            }
            Miapi.LOGGER.info("Loaded " + size + " Skins");
        });
    }

    public static SkinTab getTag(String path) {
        return tabMap.getOrDefault(path, defaultTab);
    }

    public static void load(class_2960 path, String data) {
        JsonObject element = (JsonObject)Miapi.gson.fromJson(data, JsonObject.class);
        Skin.fromJson((JsonElement)element).forEach(skin -> {
            skin.modID = path.method_12836();
            Map skinMap = skins.computeIfAbsent(skin.module.id(), module -> new HashMap());
            skinMap.put(skin.path, skin);
        });
    }

    public static void loadTabData(String data) {
        JsonObject element = (JsonObject)Miapi.gson.fromJson(data, JsonObject.class);
        SkinTab tab = SkinTab.fromJson((JsonElement)element);
        tabMap.put(tab.path, tab);
    }

    @Override
    public class_1799 preview(class_2540 buffer, EditOption.EditContext context) {
        String skin = buffer.method_19772();
        if (context.getInstance() != null) {
            Skin.writeSkin(context.getInstance(), skin);
            class_1799 stack = context.getItemstack().method_7972();
            context.getInstance().getRoot().writeToItem(stack);
            context.getInstance().clearCaches();
            return stack;
        }
        Miapi.LOGGER.error("could not set skin, no module found");
        return context.getItemstack();
    }

    @Override
    public boolean isVisible(EditOption.EditContext context) {
        ItemModule module;
        if (context.getInstance() != null && (module = context.getInstance().module) != null) {
            Map<String, Skin> foundSkins = skins.get(module.id());
            return foundSkins != null;
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InteractAbleWidget getGui(int x, int y, int width, int height, EditOption.EditContext context) {
        return new SkinGui(x, y, width, height, context.getItemstack(), context.getInstance(), context::craft, context::preview);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InteractAbleWidget getIconGui(int x, int y, int width, int height, Consumer<EditOption> select, Supplier<EditOption> getSelected) {
        return new EditOptionIcon(x, y, width, height, select, getSelected, CraftingScreen.BACKGROUND_TEXTURE, 371, 81, 512, 512, "miapi.ui.edit_option.hover.skin", this);
    }
}

