/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import smartin.miapi.Miapi;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.EditorError;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class DisplayNameProperty
extends CodecProperty<class_2561> {
    public static final class_2960 KEY = Miapi.id("display_name");
    public static DisplayNameProperty property;

    public DisplayNameProperty() {
        super(class_8824.field_46597);
        property = this;
        ModularItemCache.setSupplier(KEY.toString(), DisplayNameProperty::resolveDisplayText);
    }

    public static class_2561 getDisplayText(class_1799 stack) {
        return (class_2561)ModularItemCache.getVisualOnlyCache(stack, KEY.toString(), class_2561.method_43473());
    }

    @Override
    public List<EditorError> validate(int line, class_2561 component, boolean isClient) {
        String regex = "^[a-z_-]+(?:\\.[a-z._-]+)";
        String string = component.getString();
        if (Pattern.matches(regex, string) && class_2561.method_43471((String)string).getString().equals(string)) {
            return List.of(new EditorError(line, "translation seems to be missing!", EditorError.ErrorSeverity.WARNING));
        }
        return List.of();
    }

    private static class_2561 resolveDisplayText(class_1799 itemStack) {
        class_5250 name = class_2561.method_43471((String)"miapi.name.missing.nomodule");
        ModuleInstance root = ItemModule.getModules(itemStack);
        for (ModuleInstance moduleInstance : root.allSubModules()) {
            Optional componentOptional = property.getData(moduleInstance);
            if (!componentOptional.isPresent()) continue;
            Material material = MaterialProperty.getMaterial(moduleInstance);
            if (material != null) {
                class_2561 materialTranslation = material.getTranslation();
                name = class_2561.method_43469((String)((class_2561)componentOptional.get()).getString(), (Object[])new Object[]{materialTranslation});
                continue;
            }
            name = class_2561.method_43469((String)((class_2561)componentOptional.get()).getString(), (Object[])new Object[]{""});
        }
        return name;
    }

    @Override
    public class_2561 merge(class_2561 left, class_2561 right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }
}

