/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.inventory;

import com.redpxnda.nucleus.util.Color;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_9288;
import org.joml.Vector4i;
import smartin.miapi.Miapi;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.inventory.InventoryProperty;

public class ItemInventoryManager {
    public static final Map<class_2960, Function<class_1657, SlotInfo>> PLAYER_TO_SLOT = new HashMap<class_2960, Function<class_1657, SlotInfo>>();
    public static final Map<class_2960, Function<class_1799, InventoryType>> CONTAINERS_FOR_ITEMSTACK = new HashMap<class_2960, Function<class_1799, InventoryType>>();
    public static class_304 open = MiapiClient.KEY_BINDINGS.register(Miapi.id("open_backpack"), new class_304("miapi.binding.open_backpack", 0, "miapi.binding"));

    public static void setup() {
        ItemInventoryManager.registerArmorSlots();
        CONTAINERS_FOR_ITEMSTACK.put(Miapi.id("backpack"), stack -> {
            Optional<Double> size = InventoryProperty.property.getValue((class_1799)stack);
            if (size.isPresent()) {
                return new BackpackInventory((class_1799)stack, size.get());
            }
            return null;
        });
        MiapiEvents.PLAYER_TICK_END.register((Object)new MiapiEvents.PlayerTickEvent(){

            @Override
            public EventResult tick(class_1657 player) {
                if (!open.method_1436() || player.method_37908().field_9236) {
                    // empty if block
                }
                return EventResult.pass();
            }
        });
    }

    private static void registerArmorSlots() {
        for (class_1304 slot : class_1304.values()) {
            if (slot.method_5925() != class_1304.class_1305.field_6178) continue;
            Color color = new Color((Vector4i)Color.AQUA);
            PLAYER_TO_SLOT.put(Miapi.id("armor_" + slot.method_5923()), player -> new ArmorSlotInfo((class_1657)player, slot, color));
        }
    }

    public static Map<SlotInfo, List<InventoryType>> getInventoryForPlayer(class_1657 player) {
        HashMap<SlotInfo, List<InventoryType>> map = new HashMap<SlotInfo, List<InventoryType>>();
        PLAYER_TO_SLOT.forEach((id, function) -> {
            SlotInfo info = (SlotInfo)function.apply(player);
            if (!info.getStack().method_7960()) {
                ArrayList inventoryTypes = new ArrayList();
                CONTAINERS_FOR_ITEMSTACK.forEach((slotId, inventoryTypeFunction) -> {
                    InventoryType type = (InventoryType)inventoryTypeFunction.apply(info.getStack());
                    if (type != null && type.getSize() > 0) {
                        inventoryTypes.add(type);
                    }
                });
                if (!inventoryTypes.isEmpty()) {
                    map.put(info, inventoryTypes);
                }
            }
        });
        return map;
    }

    public static interface SlotInfo {
        public class_1799 getStack();

        public Color getColor();

        public class_2561 getName();

        public void renderIcon(int var1, int var2, int var3, int var4);

        public void setStack(class_1799 var1);
    }

    public static interface InventoryType {
        public class_9288 getContents();

        public boolean canEnter(class_1799 var1);

        public int getSize();

        public void saveToItem();

        public class_2561 getName();
    }

    public static class ArmorSlotInfo
    implements SlotInfo {
        private final class_1657 player;
        private final class_1304 slot;
        private final Color color;

        public ArmorSlotInfo(class_1657 player, class_1304 slot, Color color) {
            this.player = player;
            this.slot = slot;
            this.color = color;
        }

        @Override
        public class_1799 getStack() {
            return this.player.method_6118(this.slot);
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public class_2561 getName() {
            return class_2561.method_43471((String)("miapi.slot.armor." + this.slot.method_5923()));
        }

        @Override
        public void renderIcon(int x, int y, int width, int height) {
        }

        @Override
        public void setStack(class_1799 stack) {
            this.player.method_5673(this.slot, stack);
        }
    }

    public static class BackpackInventory
    implements InventoryType {
        private final class_1799 stack;
        private final int size;

        public BackpackInventory(class_1799 stack, double size) {
            this.stack = stack;
            this.size = (int)size;
        }

        @Override
        public class_9288 getContents() {
            return class_9288.method_57493(List.of());
        }

        @Override
        public boolean canEnter(class_1799 itemStack) {
            return true;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void saveToItem() {
        }

        @Override
        public class_2561 getName() {
            return class_2561.method_43471((String)"miapi.inventory.backpack");
        }
    }
}

