/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.potion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9274;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.InitializeAble;
import smartin.miapi.modules.properties.util.MergeType;

public record PossibleEffect(class_6880<class_1291> potion, DoubleOperationResolvable amplifier, DoubleOperationResolvable duration, DoubleOperationResolvable ambient, DoubleOperationResolvable showParticle, DoubleOperationResolvable showIcon, DoubleOperationResolvable probability, DoubleOperationResolvable targetSelf, class_9274 group) implements InitializeAble<PossibleEffect>
{
    public static final Codec<PossibleEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1291.field_51933.fieldOf("potion").forGetter(PossibleEffect::potion), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("amplifier", (Object)new DoubleOperationResolvable(0.0)).forGetter(PossibleEffect::amplifier), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("duration", (Object)new DoubleOperationResolvable(0.0)).forGetter(PossibleEffect::duration), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("ambient", (Object)new DoubleOperationResolvable(0.0)).forGetter(PossibleEffect::ambient), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("show_particles", (Object)new DoubleOperationResolvable(1.0)).forGetter(PossibleEffect::showParticle), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("show_icon", (Object)new DoubleOperationResolvable(1.0)).forGetter(PossibleEffect::showIcon), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("probability", (Object)new DoubleOperationResolvable(1.0)).forGetter(PossibleEffect::showIcon), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("target_self", (Object)new DoubleOperationResolvable(1.0)).forGetter(PossibleEffect::showIcon), (App)class_9274.field_49226.optionalFieldOf("equipment_slot", (Object)class_9274.field_49216).forGetter(PossibleEffect::group)).apply((Applicative)instance, PossibleEffect::new));
    public static final class_9139<class_9129, PossibleEffect> STREAM_CODEC = class_9135.method_56896(CODEC);

    public class_1293 getEffect() {
        return new class_1293(this.potion(), (int)this.duration().getValue(), (int)this.amplifier().getValue(), this.ambient().isTrue(), this.showParticle().isTrue(), this.showIcon().isTrue());
    }

    public void apply(class_1309 wielder, class_5819 random, class_1304 equipmentSlot, class_1309 target, class_1309 selfTarget) {
        if (this.group().method_57286(equipmentSlot)) {
            if (this.targetSelf().isTrue()) {
                target = selfTarget;
            }
            if (target != null && (this.probability().getValue() == 1.0 || random.method_43058() < this.probability().getValue())) {
                target.method_37222(this.getEffect(), (class_1297)wielder);
            }
        }
    }

    public void apply(List<PossibleEffect> effects, class_1309 wielder, class_5819 random, class_1304 equipmentSlot, class_1309 target, class_1309 selfTarget) {
        effects.forEach(effect -> effect.apply(wielder, random, equipmentSlot, target, selfTarget));
    }

    public class_2561 getTooltip(String key, String showTargetSelf) {
        return class_2561.method_43469((String)(this.targetSelf().isTrue() ? key : showTargetSelf), (Object[])new Object[]{((class_1291)this.potion().comp_349()).method_5560(), (int)this.duration().getValue() / 20, (int)this.amplifier().getValue() + 1, this.probability().getValue() == 1.0 ? class_2561.method_43473() : this.probability()});
    }

    public static List<class_2561> getTooltip(class_2561 header, List<PossibleEffect> effects, String key, String showTargetSelf) {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        if (!effects.isEmpty()) {
            components.add((class_2561)class_2561.method_43473());
            components.add(header);
            for (PossibleEffect effect : effects) {
                components.add(effect.getTooltip(key, showTargetSelf));
            }
        }
        return components;
    }

    public static void applyEffects(class_1309 target, class_1309 itemsFromEntity, Function<class_1799, List<PossibleEffect>> effectGetter) {
        PossibleEffect.applyEffects(target, target, itemsFromEntity, effectGetter);
    }

    public static void applyEffects(class_1309 target, class_1309 selfTarget, class_1309 itemsFromEntity, Function<class_1799, List<PossibleEffect>> effectGetter) {
        for (class_1304 slot : class_1304.values()) {
            itemsFromEntity.method_6118(slot);
            effectGetter.apply(itemsFromEntity.method_6118(slot)).forEach(possibleEffect -> possibleEffect.apply(itemsFromEntity, itemsFromEntity.method_37908().method_8409(), slot, target, selfTarget));
        }
    }

    public static List<PossibleEffect> merge(List<PossibleEffect> left, List<PossibleEffect> right, MergeType mergeType) {
        ArrayList<PossibleEffect> mergedList = new ArrayList<PossibleEffect>();
        ArrayList<PossibleEffect> directMerged = new ArrayList<PossibleEffect>(left);
        directMerged.addAll(right);
        directMerged.forEach(possibleEffect -> {
            Optional<PossibleEffect> mergeWith = mergedList.stream().filter(possibleEffect1 -> possibleEffect1.potion().equals(possibleEffect.potion()) && possibleEffect1.targetSelf().isTrue() == possibleEffect.targetSelf().isTrue() && (int)possibleEffect1.amplifier().getValue() == (int)possibleEffect.amplifier().getValue()).findFirst();
            if (mergeWith.isPresent()) {
                PossibleEffect first = mergeWith.get();
                mergedList.remove(first);
                double combinedProbability = first.probability().getValue() + possibleEffect.probability().getValue();
                int combinedDuration = (int)(first.duration().getValue() + (combinedProbability > 1.0 ? (double)((int)(first.duration().getValue() * (combinedProbability - 1.0))) : first.duration().getValue()));
                combinedProbability = Math.min(combinedProbability, 1.0);
                mergedList.add(new PossibleEffect(first.potion, DoubleOperationResolvable.merge(first.amplifier, possibleEffect.amplifier, mergeType), new DoubleOperationResolvable(combinedDuration), DoubleOperationResolvable.merge(first.ambient, possibleEffect.ambient, mergeType), DoubleOperationResolvable.merge(first.showParticle, possibleEffect.showParticle, mergeType), DoubleOperationResolvable.merge(first.showIcon, possibleEffect.showIcon, mergeType), new DoubleOperationResolvable(combinedProbability), first.targetSelf, first.group()));
            } else {
                mergedList.add((PossibleEffect)possibleEffect);
            }
        });
        return mergedList;
    }

    @Override
    public PossibleEffect initialize(PossibleEffect original, ModuleInstance moduleInstance) {
        return new PossibleEffect(original.potion(), original.amplifier().initialize(moduleInstance), original.duration().initialize(moduleInstance), original.ambient().initialize(moduleInstance), original.showParticle().initialize(moduleInstance), original.showIcon().initialize(moduleInstance), original.probability().initialize(moduleInstance), original.targetSelf().initialize(moduleInstance), original.group());
    }
}

