/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeType;

@Environment(value=EnvType.CLIENT)
public class ModelTransformationProperty
extends CodecProperty<ModelTransformationData> {
    public static final class_2960 KEY = Miapi.id("model_transform");
    public static ModelTransformationProperty property;

    public ModelTransformationProperty() {
        super(AutoCodec.of(ModelTransformationData.class).codec());
        property = this;
        MiapiItemModel.modelTransformersSuppler.add((itemStack, modelType, itemDisplayContext) -> {
            ModelTransformationData data = property.getData(itemStack).orElseGet(ModelTransformationData::new);
            class_804 transforms = data.asItemTransforms().method_3503(itemDisplayContext);
            if (transforms != null) {
                return (matrices, tickDelta) -> {
                    ModelTransformationProperty.applyTransformation(transforms, data.fix_left && ModelTransformationProperty.isLeftHanded(itemDisplayContext), matrices);
                    return matrices;
                };
            }
            return null;
        });
    }

    public static void applyTransformation(class_804 transformation, boolean fixLeft, class_4587 matrices) {
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        if (transformation != null) {
            transformation.method_23075(fixLeft, matrices);
        }
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
    }

    public static class_809 getTransformation(class_1799 stack) {
        return property.getData(stack).orElseGet(ModelTransformationData::new).asItemTransforms();
    }

    public static boolean isLeftHanded(class_811 mode) {
        return switch (mode) {
            case class_811.field_4323, class_811.field_4321 -> true;
            default -> false;
        };
    }

    public static Transform makeLeft(Transform transform) {
        transform = transform.copy();
        transform.translation.set((Vector3fc)new Vector3f(-transform.translation.x(), transform.translation.y(), transform.translation.z()));
        Matrix4f m = transform.toMatrix();
        m.rotate((float)Math.PI, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        m.rotate((float)Math.PI, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        m.rotate((float)Math.PI, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f));
        Transform rotated = Transform.fromMatrix(m);
        rotated.origin = transform.origin;
        return rotated;
    }

    private static Set<String> getStringOfMode(class_811 mode) {
        ArrayList<String> modes = new ArrayList<String>();
        modes.add(mode.toString());
        modes.add(mode.toString().replace("_", ""));
        modes.add(mode.toString().toLowerCase());
        modes.add(mode.toString().toLowerCase().replace("_", ""));
        switch (mode) {
            case field_4317: {
                modes.add("gui");
                break;
            }
            case field_4316: {
                modes.add("head");
                break;
            }
            case field_4319: {
                modes.add("fixed");
                break;
            }
            case field_4318: {
                modes.add("ground");
                break;
            }
            case field_4321: {
                modes.add("firstperson_lefthand");
                break;
            }
            case field_4322: {
                modes.add("firstperson_righthand");
                break;
            }
            case field_4323: {
                modes.add("thirdperson_lefthand");
                break;
            }
            case field_4320: {
                modes.add("thirdperson_righthand");
            }
        }
        return Set.copyOf(modes);
    }

    @Override
    public ModelTransformationData merge(ModelTransformationData left, ModelTransformationData right, MergeType mergeType) {
        return ModelTransformationData.merge(left, right, mergeType);
    }

    public static class ModelTransformationData {
        @CodecBehavior.Optional
        public Transform gui = null;
        @CodecBehavior.Optional
        public Transform head = null;
        @CodecBehavior.Optional
        public Transform fixed = null;
        @CodecBehavior.Optional
        public Transform ground = null;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="firstperson_lefthand")
        public Transform firstPersonLeftHand = null;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="firstperson_righthand")
        public Transform firstPersonRightHand = null;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="thirdperson_lefthand")
        public Transform thirdPersonLeftHand = null;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="thirdperson_righthand")
        public Transform thirdPersonRightHand = null;
        @CodecBehavior.Optional
        public boolean overwrite = true;
        @CodecBehavior.Optional
        public boolean fix_left = false;

        public static ModelTransformationData merge(ModelTransformationData left, ModelTransformationData right, MergeType mergeType) {
            ModelTransformationData data = new ModelTransformationData();
            if (right.overwrite) {
                data.gui = ModelTransformationData.overwrite(left.gui, right.gui);
                data.head = ModelTransformationData.overwrite(left.head, right.head);
                data.fixed = ModelTransformationData.overwrite(left.fixed, right.fixed);
                data.ground = ModelTransformationData.overwrite(left.ground, right.ground);
                data.firstPersonLeftHand = ModelTransformationData.overwrite(left.firstPersonLeftHand, right.firstPersonLeftHand);
                data.firstPersonRightHand = ModelTransformationData.overwrite(left.firstPersonRightHand, right.firstPersonRightHand);
                data.thirdPersonLeftHand = ModelTransformationData.overwrite(left.thirdPersonLeftHand, right.thirdPersonLeftHand);
                data.thirdPersonRightHand = ModelTransformationData.overwrite(left.thirdPersonRightHand, right.thirdPersonRightHand);
                data.fix_left = right.fix_left;
            } else {
                data.gui = ModelTransformationData.merge(left.gui, right.gui);
                data.head = ModelTransformationData.merge(left.head, right.head);
                data.fixed = ModelTransformationData.merge(left.fixed, right.fixed);
                data.ground = ModelTransformationData.merge(left.ground, right.ground);
                data.firstPersonLeftHand = ModelTransformationData.merge(left.firstPersonLeftHand, right.firstPersonLeftHand);
                data.firstPersonRightHand = ModelTransformationData.merge(left.firstPersonRightHand, right.firstPersonRightHand);
                data.thirdPersonLeftHand = ModelTransformationData.merge(left.thirdPersonLeftHand, right.thirdPersonLeftHand);
                data.thirdPersonRightHand = ModelTransformationData.merge(left.thirdPersonRightHand, right.thirdPersonRightHand);
                data.fix_left = left.fix_left;
            }
            return data;
        }

        public static Transform merge(@Nullable Transform left, @Nullable Transform right) {
            if (left == null && right == null) {
                return null;
            }
            if (left != null && right == null) {
                return left.copy();
            }
            if (left == null && right != null) {
                return right.copy();
            }
            return Transform.merge(left, right);
        }

        public static Transform overwrite(@Nullable Transform left, @Nullable Transform right) {
            if (right == null) {
                return left != null ? left.copy() : null;
            }
            return right.copy();
        }

        public class_809 asItemTransforms() {
            return new class_809(this.thirdPersonLeftHand != null ? this.thirdPersonLeftHand.toTransformation() : Transform.IDENTITY.toTransformation(), this.thirdPersonRightHand != null ? this.thirdPersonRightHand.toTransformation() : Transform.IDENTITY.toTransformation(), this.firstPersonLeftHand != null ? this.firstPersonLeftHand.toTransformation() : Transform.IDENTITY.toTransformation(), this.firstPersonRightHand != null ? this.firstPersonRightHand.toTransformation() : Transform.IDENTITY.toTransformation(), this.head != null ? this.head.toTransformation() : Transform.IDENTITY.toTransformation(), this.gui != null ? this.gui.toTransformation() : Transform.IDENTITY.toTransformation(), this.ground != null ? this.ground.toTransformation() : Transform.IDENTITY.toTransformation(), this.fixed != null ? this.fixed.toTransformation() : Transform.IDENTITY.toTransformation());
        }
    }
}

