/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.BakedMiapiModel;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.client.model.ModelHolder;
import smartin.miapi.client.renderer.RescaledVertexConsumer;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.render.colorproviders.ColorProvider;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class OverlayModelProperty
extends CodecProperty<List<OverlayModelData>> {
    public static Codec<List<OverlayModelData>> CODEC = Codec.list((Codec)AutoCodec.of(OverlayModelData.class).codec());
    public static final class_2960 KEY = Miapi.id("overlay_texture_model");
    public static OverlayModelProperty property;

    public OverlayModelProperty() {
        super(CODEC);
        property = this;
        MiapiItemModel.modelSuppliers.add(new MiapiItemModel.ModelSupplier(){

            @Override
            public List<MiapiModel> getModels(String key, @Nullable class_811 model, ModuleInstance module, class_1799 stack) {
                ArrayList<MiapiModel> models = new ArrayList<MiapiModel>();
                ModuleInstance moduleInstance = module;
                for (ModuleInstance module2 : ItemModule.getModules(stack).allSubModules()) {
                    for (OverlayModelData modelData : (List)OverlayModelProperty.this.getData(module2).orElse(new ArrayList())) {
                        if (modelData.onlyOnSameModule() && !moduleInstance.equals(module2)) continue;
                        List list = ModelProperty.property.getData(moduleInstance).orElse(new ArrayList());
                        list.forEach(modelJson -> {
                            ModelHolder holder;
                            if (modelData.isValid((ModelProperty.ModelData)modelJson) && (holder = ModelProperty.bakedModel(moduleInstance, modelJson, stack, key)) != null) {
                                ColorProvider colorProvider = modelData.getColorProvider(stack, module2, moduleInstance, holder.colorProvider());
                                class_1058 overWriteSprite = modelData.resolveSprite();
                                models.add(OverlayModelProperty.this.getBakedMiapiModel(module, stack, modelData, moduleInstance, holder, colorProvider, overWriteSprite));
                            }
                        });
                    }
                }
                return models;
            }

            @Override
            public List<Pair<Matrix4f, MiapiModel>> filter(List<Pair<Matrix4f, MiapiModel>> oldModels, class_1799 stack, ModuleInstance module, String key, class_811 context) {
                ArrayList models = new ArrayList();
                return oldModels;
            }

            private static /* synthetic */ boolean lambda$filter$1(AtomicReference matrix4f, Pair a) {
                if (a.getSecond() instanceof BakedMiapiModel) {
                    matrix4f.set((Matrix4f)a.getFirst());
                }
                return !(a.getSecond() instanceof BakedMiapiModel);
            }
        });
    }

    @NotNull
    private BakedMiapiModel getBakedMiapiModel(final ModuleInstance module, class_1799 stack, final OverlayModelData modelData, ModuleInstance moduleInstance, ModelHolder holder, final ColorProvider colorProvider, final @Nullable class_1058 overWriteSprite) {
        return new BakedMiapiModel(new ModelHolder(holder.model(), new Matrix4f((Matrix4fc)holder.matrix4f()), new ColorProvider(){

            @Override
            public class_4588 getConsumer(class_4597 vertexConsumers, class_1058 sprite, class_1799 stack, ModuleInstance moduleInstance, class_811 mode) {
                return new RescaledVertexConsumer(colorProvider.getConsumer(vertexConsumers, overWriteSprite == null ? sprite : overWriteSprite, stack, modelData.useThisModule() ? module : moduleInstance, mode), sprite);
            }

            @Override
            public ColorProvider getInstance(class_1799 stack, ModuleInstance instance) {
                return this;
            }
        }, new int[]{-1, -1}, holder.trimMode(), holder.entityRendering()), modelData.useThisModule() ? module : moduleInstance, stack);
    }

    @Override
    public boolean load(class_2960 id, JsonElement element, boolean isClient) throws Exception {
        ((List)this.decode(element)).forEach(OverlayModelData::loadSprite);
        return isClient;
    }

    @Override
    public List<OverlayModelData> merge(List<OverlayModelData> left, List<OverlayModelData> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    public static class OverlayModelData {
        @CodecBehavior.Optional
        public String texture;
        public String modelTargetType;
        public String modelTargetInfo;
        public String colorProvider;
        @CodecBehavior.Optional
        public double javaPriority = 0.0;
        @CodecBehavior.Optional
        public boolean allowOtherModules = false;

        @Nullable
        public class_1058 resolveSprite() {
            if (this.texture == null) {
                return null;
            }
            return ModelProperty.textureGetter.apply(new class_4730(class_1059.field_5275, class_2960.method_60654((String)this.texture)));
        }

        public void loadSprite() {
            if (this.texture != null) {
                ModelProperty.textureGetter.apply(new class_4730(class_1059.field_5275, class_2960.method_60654((String)this.texture)));
            }
        }

        public ColorProvider getColorProvider(class_1799 itemStack, ModuleInstance current, ModuleInstance other, ColorProvider otherColor) {
            switch (this.colorProvider) {
                case "this": {
                    return ColorProvider.getProvider("material", itemStack, current);
                }
                case "other": {
                    return otherColor;
                }
            }
            if (ColorProvider.colorProviders.containsKey(this.colorProvider)) {
                return ColorProvider.getProvider(this.colorProvider, itemStack, current);
            }
            if (this.colorProvider.startsWith("material:")) {
                class_2960 materialId = class_2960.method_60654((String)this.colorProvider.split(":", 2)[1]);
                Material material = MaterialProperty.MATERIAL_REGISTRY.get(materialId);
                if (material != null) {
                    return new ColorProvider.MaterialColorProvider(material);
                }
                Miapi.LOGGER.error("Could not find Material " + String.valueOf(materialId) + " for Color Provider ");
            }
            return otherColor;
        }

        public boolean useThisModule() {
            return !this.colorProvider.equals("other");
        }

        public boolean onlyOnSameModule() {
            return !this.allowOtherModules;
        }

        public boolean isValid(ModelProperty.ModelData modelJson) {
            Pattern pattern = Pattern.compile(this.modelTargetInfo);
            switch (this.modelTargetType) {
                case "id": {
                    return pattern.matcher(modelJson.id).find();
                }
                case "path": {
                    return pattern.matcher(modelJson.path).find();
                }
            }
            return false;
        }
    }
}

