/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.network.NetworkingImpl;
import smartin.miapi.network.modern.ModernNetworking;
import smartin.miapi.network.modern.payload.CustomPayload;
import smartin.miapi.network.payload.C2SMiapiOLDPayload;
import smartin.miapi.network.payload.S2CMiapiOLDPayload;

public class NetworkingImplCommon
extends NetworkingImpl {
    protected NetworkingImplCommon instance = this;

    public NetworkingImplCommon() {
        try {
            if (Environment.isClient()) {
                NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, S2CMiapiOLDPayload.TYPE, S2CMiapiOLDPayload.STREAM_CODEC, (packet, context) -> {});
            } else {
                NetworkManager.registerS2CPayloadType(S2CMiapiOLDPayload.TYPE, S2CMiapiOLDPayload.STREAM_CODEC);
            }
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, C2SMiapiOLDPayload.PACKET_TYPE, C2SMiapiOLDPayload.STREAM_CODEC, (packet, context) -> {});
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("could not setup networking", (Throwable)e);
        }
        ModernNetworking.setup();
    }

    public void setupServer() {
    }

    @Override
    public void sendPacketToServer(String identifier, class_2540 buffer) {
        UUID player = class_310.method_1551().field_1724.method_5667();
        NetworkManager.sendToServer((class_8710)new C2SMiapiOLDPayload(new CustomPayload(identifier, player, buffer.array())));
    }

    @Override
    public void sendPacketToClient(String identifier, class_3222 player, class_2540 buffer) {
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new S2CMiapiOLDPayload(new CustomPayload(identifier, player.method_5667(), buffer.array())));
    }

    @Override
    public class_2540 createBuffer() {
        return new class_2540(Unpooled.buffer());
    }
}

