/*
 * Decompiled with CFR 0.152.
 */
package eu.prismm;

import eu.prismm.ExceptionLogger;
import eu.prismm.FilterConfig;
import eu.prismm.SpamFilter;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class NoConsoleSpam
implements ModInitializer,
PreLaunchEntrypoint {
    public static final String MOD_ID = "noconsolespam";
    public static final String VERSION = "1.4.4";
    private static final Logger LOGGER = LogManager.getLogger((String)"noconsolespam");
    private FilterConfig filterConfig;
    private ExceptionLogger exceptionLogger;

    public void onPreLaunch() {
        block3: {
            LOGGER.info("Pre-initializing NoConsoleSpam v{}", (Object)VERSION);
            try {
                this.filterConfig = new FilterConfig();
                this.exceptionLogger = new ExceptionLogger(this.filterConfig.getExceptionSettings());
                this.configureLogging();
            }
            catch (Exception e) {
                LOGGER.error("Failed to pre-initialize NoConsoleSpam", (Throwable)e);
                if (this.filterConfig == null) {
                    this.filterConfig = new FilterConfig();
                }
                if (this.exceptionLogger != null) break block3;
                this.exceptionLogger = new ExceptionLogger(this.filterConfig.getExceptionSettings());
            }
        }
    }

    public void onInitialize() {
        LOGGER.info("Initializing NoConsoleSpam v{}", (Object)VERSION);
        try {
            if (this.filterConfig == null) {
                LOGGER.warn("FilterConfig was null, initializing now...");
                this.filterConfig = new FilterConfig();
            }
            if (this.exceptionLogger == null) {
                LOGGER.warn("ExceptionLogger was null, initializing now...");
                this.exceptionLogger = new ExceptionLogger(this.filterConfig.getExceptionSettings());
            }
            LOGGER.info("NoConsoleSpam is now filtering console spam");
            FilterConfig.ExceptionSettings exSettings = this.filterConfig.getExceptionSettings();
            if (exSettings.isCaptureExceptions()) {
                LOGGER.info("Exception logging is enabled with the following settings:");
                LOGGER.info("  - Organizing by source: {}", (Object)exSettings.isOrganizeBySource());
                LOGGER.info("  - Runtime exceptions: {}", (Object)exSettings.isCaptureRuntimeExceptions());
                LOGGER.info("  - IO exceptions: {}", (Object)exSettings.isCaptureIOExceptions());
                LOGGER.info("  - Fabric exceptions: {}", (Object)exSettings.isCaptureFabricExceptions());
                LOGGER.info("  - Minecraft exceptions: {}", (Object)exSettings.isCaptureMinecraftExceptions());
                LOGGER.info("  - Reflection exceptions: {}", (Object)exSettings.isCaptureReflectionExceptions());
                LOGGER.info("  - Security exceptions: {}", (Object)exSettings.isCaptureSecurityExceptions());
                LOGGER.info("  - Network exceptions: {}", (Object)exSettings.isCaptureNetworkExceptions());
                LOGGER.info("  - Data exceptions: {}", (Object)exSettings.isCaptureDataExceptions());
                LOGGER.info("  - JVM Errors: {}", (Object)exSettings.isCaptureErrors());
                LOGGER.info("  - Concurrent exceptions: {}", (Object)exSettings.isCaptureConcurrentExceptions());
                LOGGER.info("  - Max backup files: {}", (Object)exSettings.getMaxBackupIndex());
                LOGGER.info("Exception logs will be saved to: {}", (Object)"Console Errors/[source]/[timestamp]_[type].log");
            } else {
                LOGGER.info("Exception logging is disabled");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize NoConsoleSpam", (Throwable)e);
        }
    }

    private void configureLogging() {
        try {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            LoggerConfig rootLogger = config.getRootLogger();
            rootLogger.addFilter((Filter)new SpamFilter(this.filterConfig.getSpamPatterns(), this.filterConfig.getIgnoredLoggers(), this.exceptionLogger));
            context.updateLoggers();
            LOGGER.info("Console spam filtering activated with {} patterns and {} ignored loggers", (Object)this.filterConfig.getSpamPatterns().size(), (Object)this.filterConfig.getIgnoredLoggers().size());
        }
        catch (Exception e) {
            LOGGER.error("Failed to configure logging", (Throwable)e);
        }
    }
}

