/*
 * Decompiled with CFR 0.152.
 */
package eu.prismm;

import eu.prismm.ExceptionLogger;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

public class SpamFilter
extends AbstractFilter {
    private final Set<Pattern> spamPatterns;
    private final Set<String> ignoredLoggers;
    private final ExceptionLogger exceptionLogger;

    public SpamFilter(Set<Pattern> spamPatterns, Set<String> ignoredLoggers, ExceptionLogger exceptionLogger) {
        this.spamPatterns = spamPatterns != null ? spamPatterns : new HashSet();
        this.ignoredLoggers = ignoredLoggers != null ? ignoredLoggers : new HashSet();
        this.exceptionLogger = exceptionLogger;
    }

    public Filter.Result filter(LogEvent event) {
        if (event == null) {
            return Filter.Result.NEUTRAL;
        }
        try {
            Throwable throwable;
            if (this.ignoredLoggers.contains(event.getLoggerName())) {
                return Filter.Result.DENY;
            }
            String message = "";
            if (event.getMessage() != null) {
                try {
                    message = event.getMessage().getFormattedMessage();
                }
                catch (Exception e) {
                    message = event.getMessage().toString();
                }
            }
            if ((throwable = event.getThrown()) != null && this.exceptionLogger != null && this.exceptionLogger.isInitialized()) {
                try {
                    String loggerContext = event.getLoggerName() != null ? "[Logger: " + event.getLoggerName() + "] " : "";
                    String levelContext = "[Level: " + String.valueOf(event.getLevel()) + "] ";
                    String threadContext = "[Thread: " + event.getThreadName() + "] ";
                    String contextualMessage = loggerContext + levelContext + threadContext + message;
                    this.exceptionLogger.logException(contextualMessage, throwable);
                }
                catch (Exception ex) {
                    System.err.println("Failed to log exception: " + ex.getMessage());
                }
            }
            if (message != null && !message.isEmpty()) {
                for (Pattern pattern : this.spamPatterns) {
                    try {
                        if (!pattern.matcher(message).matches()) continue;
                        return Filter.Result.DENY;
                    }
                    catch (Exception e) {
                        System.err.println("Error matching pattern: " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error in SpamFilter: " + e.getMessage());
        }
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        try {
            return this.filter(new SimpleLogEvent(logger.getName(), level, marker, msg, t));
        }
        catch (Exception e) {
            System.err.println("Error in filter method: " + e.getMessage());
            return Filter.Result.NEUTRAL;
        }
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        if (msg == null) {
            return Filter.Result.NEUTRAL;
        }
        try {
            SimpleMessage message = new SimpleMessage(msg.toString());
            return this.filter(new SimpleLogEvent(logger.getName(), level, marker, message, t));
        }
        catch (Exception e) {
            System.err.println("Error in filter method with object message: " + e.getMessage());
            return Filter.Result.NEUTRAL;
        }
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        if (msg == null) {
            return Filter.Result.NEUTRAL;
        }
        try {
            SimpleMessage message = new SimpleMessage(msg);
            return this.filter(new SimpleLogEvent(logger.getName(), level, marker, message, null));
        }
        catch (Exception e) {
            System.err.println("Error in filter method with string message: " + e.getMessage());
            return Filter.Result.NEUTRAL;
        }
    }

    private static class SimpleLogEvent
    implements LogEvent {
        private final String loggerName;
        private final Level level;
        private final Marker marker;
        private final Message message;
        private final Throwable throwable;
        private final MutableInstant instant = new MutableInstant();
        private boolean endOfBatch;

        SimpleLogEvent(String loggerName, Level level, Marker marker, Message message, Throwable throwable) {
            this.loggerName = loggerName;
            this.level = level;
            this.marker = marker;
            this.message = message;
            this.throwable = throwable;
            this.instant.initFromEpochMilli(System.currentTimeMillis(), 0);
        }

        public Message getMessage() {
            return this.message;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public Level getLevel() {
            return this.level;
        }

        public Marker getMarker() {
            return this.marker;
        }

        public String getThreadName() {
            return Thread.currentThread().getName();
        }

        public long getTimeMillis() {
            return this.instant.getEpochMillisecond();
        }

        public Instant getInstant() {
            return this.instant;
        }

        public StackTraceElement getSource() {
            return null;
        }

        public String getLoggerFqcn() {
            return null;
        }

        public ThreadContext.ContextStack getContextStack() {
            return ThreadContext.getImmutableStack();
        }

        public Map<String, String> getContextMap() {
            return ThreadContext.getImmutableContext();
        }

        public ReadOnlyStringMap getContextData() {
            return null;
        }

        public Throwable getThrown() {
            return this.throwable;
        }

        public ThrowableProxy getThrownProxy() {
            return this.throwable != null ? new ThrowableProxy(this.throwable) : null;
        }

        public boolean isEndOfBatch() {
            return this.endOfBatch;
        }

        public void setEndOfBatch(boolean endOfBatch) {
            this.endOfBatch = endOfBatch;
        }

        public boolean isIncludeLocation() {
            return false;
        }

        public void setIncludeLocation(boolean locationRequired) {
        }

        public long getNanoTime() {
            return 0L;
        }

        public int getThreadPriority() {
            return Thread.currentThread().getPriority();
        }

        public long getThreadId() {
            return Thread.currentThread().threadId();
        }

        public LogEvent toImmutable() {
            return this;
        }
    }

    private static class SimpleMessage
    implements Message {
        private final String message;

        SimpleMessage(String message) {
            this.message = message;
        }

        public String getFormattedMessage() {
            return this.message;
        }

        public String getFormat() {
            return this.message;
        }

        public Object[] getParameters() {
            return new Object[0];
        }

        public Throwable getThrowable() {
            return null;
        }
    }
}

