/*
 * Decompiled with CFR 0.152.
 */
package eu.prismm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilterConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"noconsolespam");
    private static final String CONFIG_FILENAME = "spamfilters.json";
    private static final String CONFIG_DIRECTORY = "config/NoConsoleSpam";
    private static final String RESOURCE_CONFIG_PATH = "spamfilters.json";
    private Set<Pattern> spamPatterns = new HashSet<Pattern>();
    private Set<String> ignoredLoggers = new HashSet<String>();
    private ExceptionSettings exceptionSettings = new ExceptionSettings();
    private File configFile;

    public FilterConfig() {
        this.ensureConfigDirectoryExists();
        this.loadConfig();
    }

    private void ensureConfigDirectoryExists() {
        File configDir = new File(CONFIG_DIRECTORY);
        if (!configDir.exists()) {
            if (configDir.mkdirs()) {
                LOGGER.info("Created config directory: {}", (Object)configDir.getAbsolutePath());
            } else {
                LOGGER.error("Failed to create config directory: {}", (Object)configDir.getAbsolutePath());
            }
        }
        this.configFile = new File(configDir, "spamfilters.json");
        if (!this.configFile.exists()) {
            this.createDefaultConfigFile();
        }
    }

    private void createDefaultConfigFile() {
        block8: {
            try {
                InputStream defaultConfig = this.getClass().getClassLoader().getResourceAsStream("spamfilters.json");
                if (defaultConfig != null) {
                    Files.copy(defaultConfig, this.configFile.toPath(), new CopyOption[0]);
                    LOGGER.info("Created default config file at: {}", (Object)this.configFile.getAbsolutePath());
                    defaultConfig.close();
                    break block8;
                }
                JsonObject defaultJson = this.createDefaultJsonConfig();
                try (FileWriter writer = new FileWriter(this.configFile);){
                    new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)defaultJson, (Appendable)writer);
                }
                LOGGER.info("Created a new default config file at: {}", (Object)this.configFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.error("Failed to create default config file", (Throwable)e);
            }
        }
    }

    private JsonObject createDefaultJsonConfig() {
        JsonObject config = new JsonObject();
        JsonArray spamPatternsArray = new JsonArray();
        spamPatternsArray.add(".*Lithium.*");
        spamPatternsArray.add(".*mismatch.*");
        spamPatternsArray.add(".*overloading.*");
        spamPatternsArray.add(".*moving.*wrongly.*");
        spamPatternsArray.add(".*Class Analysis Error.*");
        config.add("spamPatterns", (JsonElement)spamPatternsArray);
        JsonArray ignoredLoggersArray = new JsonArray();
        ignoredLoggersArray.add("net.minecraft.class_5458");
        ignoredLoggersArray.add("net.minecraft.class_5459");
        ignoredLoggersArray.add("net.minecraft.class_5460");
        config.add("ignoredLoggers", (JsonElement)ignoredLoggersArray);
        JsonObject exceptionSettingsObj = new JsonObject();
        exceptionSettingsObj.addProperty("captureExceptions", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("logFile", "logs/exceptions.log");
        exceptionSettingsObj.addProperty("maxLogSize", (Number)0xA00000);
        exceptionSettingsObj.addProperty("maxBackupIndex", (Number)3);
        exceptionSettingsObj.addProperty("organizeBySource", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureRuntimeExceptions", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureIOExceptions", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureFabricExceptions", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureMinecraftExceptions", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureReflectionExceptions", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureSecurityExceptions", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureNetworkExceptions", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureDataExceptions", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureErrors", Boolean.valueOf(true));
        exceptionSettingsObj.addProperty("captureConcurrentExceptions", Boolean.valueOf(true));
        config.add("exceptionSettings", (JsonElement)exceptionSettingsObj);
        return config;
    }

    public void loadConfig() {
        try {
            InputStream stream;
            if (this.configFile.exists()) {
                try (FileReader reader = new FileReader(this.configFile);){
                    JsonObject config = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                    this.loadPatternsFromJson(config);
                    this.loadLoggersFromJson(config);
                    this.loadExceptionSettingsFromJson(config);
                    LOGGER.info("Loaded config from: {}", (Object)this.configFile.getAbsolutePath());
                    return;
                }
                catch (Exception e) {
                    LOGGER.error("Error loading config from file: {}", (Object)this.configFile.getAbsolutePath(), (Object)e);
                }
            }
            if ((stream = this.getClass().getClassLoader().getResourceAsStream("spamfilters.json")) == null) {
                LOGGER.error("Could not find spam filter configuration file. Using default patterns.");
                this.loadDefaultPatterns();
                return;
            }
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                JsonObject config = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                this.loadPatternsFromJson(config);
                this.loadLoggersFromJson(config);
                this.loadExceptionSettingsFromJson(config);
                LOGGER.info("Loaded {} spam patterns and {} ignored loggers from bundled configuration", (Object)this.spamPatterns.size(), (Object)this.ignoredLoggers.size());
            }
        }
        catch (IOException e) {
            LOGGER.error("Error loading spam filter configuration", (Throwable)e);
            this.loadDefaultPatterns();
        }
    }

    private void loadPatternsFromJson(JsonObject config) {
        this.spamPatterns.clear();
        if (config.has("spamPatterns")) {
            JsonArray patternsArray = config.getAsJsonArray("spamPatterns");
            patternsArray.forEach(element -> {
                String pattern = element.getAsString();
                try {
                    this.spamPatterns.add(Pattern.compile(pattern));
                    LOGGER.debug("Added spam pattern: {}", (Object)pattern);
                }
                catch (PatternSyntaxException e) {
                    LOGGER.error("Invalid pattern syntax: {}", (Object)pattern, (Object)e);
                }
            });
        }
    }

    private void loadLoggersFromJson(JsonObject config) {
        this.ignoredLoggers.clear();
        if (config.has("ignoredLoggers")) {
            JsonArray loggersArray = config.getAsJsonArray("ignoredLoggers");
            loggersArray.forEach(element -> {
                String logger = element.getAsString();
                this.ignoredLoggers.add(logger);
                LOGGER.debug("Added ignored logger: {}", (Object)logger);
            });
        }
    }

    private void loadExceptionSettingsFromJson(JsonObject config) {
        if (config.has("exceptionSettings")) {
            JsonObject settingsObj = config.getAsJsonObject("exceptionSettings");
            if (settingsObj.has("captureExceptions")) {
                this.exceptionSettings.setCaptureExceptions(settingsObj.get("captureExceptions").getAsBoolean());
            }
            if (settingsObj.has("logFile")) {
                this.exceptionSettings.setLogFile(settingsObj.get("logFile").getAsString());
            }
            if (settingsObj.has("maxLogSize")) {
                this.exceptionSettings.setMaxLogSize(settingsObj.get("maxLogSize").getAsLong());
            }
            if (settingsObj.has("maxBackupIndex")) {
                this.exceptionSettings.setMaxBackupIndex(settingsObj.get("maxBackupIndex").getAsInt());
            }
            if (settingsObj.has("organizeBySource")) {
                this.exceptionSettings.setOrganizeBySource(settingsObj.get("organizeBySource").getAsBoolean());
            }
            if (settingsObj.has("captureRuntimeExceptions")) {
                this.exceptionSettings.setCaptureRuntimeExceptions(settingsObj.get("captureRuntimeExceptions").getAsBoolean());
            }
            if (settingsObj.has("captureIOExceptions")) {
                this.exceptionSettings.setCaptureIOExceptions(settingsObj.get("captureIOExceptions").getAsBoolean());
            }
            if (settingsObj.has("captureFabricExceptions")) {
                this.exceptionSettings.setCaptureFabricExceptions(settingsObj.get("captureFabricExceptions").getAsBoolean());
            }
            if (settingsObj.has("captureMinecraftExceptions")) {
                this.exceptionSettings.setCaptureMinecraftExceptions(settingsObj.get("captureMinecraftExceptions").getAsBoolean());
            }
            if (settingsObj.has("captureReflectionExceptions")) {
                this.exceptionSettings.setCaptureReflectionExceptions(settingsObj.get("captureReflectionExceptions").getAsBoolean());
            }
            if (settingsObj.has("captureSecurityExceptions")) {
                this.exceptionSettings.setCaptureSecurityExceptions(settingsObj.get("captureSecurityExceptions").getAsBoolean());
            }
            if (settingsObj.has("captureNetworkExceptions")) {
                this.exceptionSettings.setCaptureNetworkExceptions(settingsObj.get("captureNetworkExceptions").getAsBoolean());
            }
            if (settingsObj.has("captureDataExceptions")) {
                this.exceptionSettings.setCaptureDataExceptions(settingsObj.get("captureDataExceptions").getAsBoolean());
            }
            if (settingsObj.has("captureErrors")) {
                this.exceptionSettings.setCaptureErrors(settingsObj.get("captureErrors").getAsBoolean());
            }
            if (settingsObj.has("captureConcurrentExceptions")) {
                this.exceptionSettings.setCaptureConcurrentExceptions(settingsObj.get("captureConcurrentExceptions").getAsBoolean());
            }
        }
    }

    private void loadDefaultPatterns() {
        this.spamPatterns.clear();
        this.ignoredLoggers.clear();
        this.spamPatterns.add(Pattern.compile(".*Lithium.*"));
        this.spamPatterns.add(Pattern.compile(".*mismatch.*"));
        this.spamPatterns.add(Pattern.compile(".*overloading.*"));
        this.spamPatterns.add(Pattern.compile(".*moving.*wrongly.*"));
        this.spamPatterns.add(Pattern.compile(".*Class Analysis Error.*"));
        this.ignoredLoggers.add("net.minecraft.class_5458");
        this.ignoredLoggers.add("net.minecraft.class_5459");
        this.ignoredLoggers.add("net.minecraft.class_5460");
        LOGGER.info("Loaded default spam patterns and ignored loggers");
    }

    public Set<Pattern> getSpamPatterns() {
        return this.spamPatterns;
    }

    public Set<String> getIgnoredLoggers() {
        return this.ignoredLoggers;
    }

    public ExceptionSettings getExceptionSettings() {
        return this.exceptionSettings;
    }

    public static class ExceptionSettings {
        private boolean captureExceptions = true;
        private String logFile = "logs/exceptions.log";
        private long maxLogSize = 0xA00000L;
        private int maxBackupIndex = 3;
        private boolean organizeBySource = true;
        private boolean captureRuntimeExceptions = true;
        private boolean captureIOExceptions = true;
        private boolean captureFabricExceptions = true;
        private boolean captureMinecraftExceptions = true;
        private boolean captureReflectionExceptions = true;
        private boolean captureSecurityExceptions = true;
        private boolean captureNetworkExceptions = true;
        private boolean captureDataExceptions = true;
        private boolean captureErrors = true;
        private boolean captureConcurrentExceptions = true;

        public boolean isCaptureExceptions() {
            return this.captureExceptions;
        }

        public void setCaptureExceptions(boolean captureExceptions) {
            this.captureExceptions = captureExceptions;
        }

        public String getLogFile() {
            return this.logFile;
        }

        public void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        public long getMaxLogSize() {
            return this.maxLogSize;
        }

        public void setMaxLogSize(long maxLogSize) {
            this.maxLogSize = maxLogSize;
        }

        public int getMaxBackupIndex() {
            return this.maxBackupIndex;
        }

        public void setMaxBackupIndex(int maxBackupIndex) {
            this.maxBackupIndex = maxBackupIndex;
        }

        public boolean isOrganizeBySource() {
            return this.organizeBySource;
        }

        public void setOrganizeBySource(boolean organizeBySource) {
            this.organizeBySource = organizeBySource;
        }

        public boolean isCaptureRuntimeExceptions() {
            return this.captureRuntimeExceptions;
        }

        public void setCaptureRuntimeExceptions(boolean captureRuntimeExceptions) {
            this.captureRuntimeExceptions = captureRuntimeExceptions;
        }

        public boolean isCaptureIOExceptions() {
            return this.captureIOExceptions;
        }

        public void setCaptureIOExceptions(boolean captureIOExceptions) {
            this.captureIOExceptions = captureIOExceptions;
        }

        public boolean isCaptureFabricExceptions() {
            return this.captureFabricExceptions;
        }

        public void setCaptureFabricExceptions(boolean captureFabricExceptions) {
            this.captureFabricExceptions = captureFabricExceptions;
        }

        public boolean isCaptureMinecraftExceptions() {
            return this.captureMinecraftExceptions;
        }

        public void setCaptureMinecraftExceptions(boolean captureMinecraftExceptions) {
            this.captureMinecraftExceptions = captureMinecraftExceptions;
        }

        public boolean isCaptureReflectionExceptions() {
            return this.captureReflectionExceptions;
        }

        public void setCaptureReflectionExceptions(boolean captureReflectionExceptions) {
            this.captureReflectionExceptions = captureReflectionExceptions;
        }

        public boolean isCaptureSecurityExceptions() {
            return this.captureSecurityExceptions;
        }

        public void setCaptureSecurityExceptions(boolean captureSecurityExceptions) {
            this.captureSecurityExceptions = captureSecurityExceptions;
        }

        public boolean isCaptureNetworkExceptions() {
            return this.captureNetworkExceptions;
        }

        public void setCaptureNetworkExceptions(boolean captureNetworkExceptions) {
            this.captureNetworkExceptions = captureNetworkExceptions;
        }

        public boolean isCaptureDataExceptions() {
            return this.captureDataExceptions;
        }

        public void setCaptureDataExceptions(boolean captureDataExceptions) {
            this.captureDataExceptions = captureDataExceptions;
        }

        public boolean isCaptureErrors() {
            return this.captureErrors;
        }

        public void setCaptureErrors(boolean captureErrors) {
            this.captureErrors = captureErrors;
        }

        public boolean isCaptureConcurrentExceptions() {
            return this.captureConcurrentExceptions;
        }

        public void setCaptureConcurrentExceptions(boolean captureConcurrentExceptions) {
            this.captureConcurrentExceptions = captureConcurrentExceptions;
        }
    }
}

