#> callyourcat:image/set_image_data
#
# This function sets the image data.
#
# @input $(image_data) {string[][]} The data to set  
# @input $(width) {number} The width of the image  
# @input $(height) {number} The height of the image  
# @input $(background_color) {string} The background color of the image  
# @input $(description) {string[]} The description on the right hand side  
# @writes storage callyourcat:image image_data  
# @writes storage callyourcat:image width  
# @writes storage callyourcat:image height  
# @writes storage callyourcat:image background_color  
# @writes storage callyourcat:image description  
# @writes storage callyourcat:image pixel_character.blank  
# @writes storage callyourcat:image pixel_character.chat  
# @writes storage callyourcat:image pixel_character.lore

data remove storage callyourcat:image image_data
data remove storage callyourcat:image width
data remove storage callyourcat:image height
data remove storage callyourcat:image background_color
data remove storage callyourcat:image description

$data modify storage callyourcat:image image_data set value $(image_data)
$data modify storage callyourcat:image width set value $(width)
$data modify storage callyourcat:image height set value $(height)
$data modify storage callyourcat:image background_color set value "$(background_color)"
$data modify storage callyourcat:image description set value $(description)

data modify storage callyourcat:image pixel_character.blank set value "　"
data modify storage callyourcat:image pixel_character.pixel set value "▌▌"
data modify storage callyourcat:image pixel_character.line_break set value '\n'

function callyourcat:image/process/generate
