package com.github.mkram17.bazaarutils;

import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.features.Bookmark;
import com.github.mkram17.bazaarutils.features.StashHelper;
import com.github.mkram17.bazaarutils.misc.BUCompatibilityHelper;
import com.github.mkram17.bazaarutils.utils.BUCommands;
import com.github.mkram17.bazaarutils.utils.Util;
import com.mojang.serialization.Codec;
import de.siphalor.amecs.api.AmecsKeyBinding;
import lombok.Getter;
import meteordevelopment.orbit.EventBus;
import meteordevelopment.orbit.IEventBus;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class BazaarUtils implements ClientModInitializer {
    public static IEventBus EVENT_BUS = new EventBus();
    public static StashHelper stashHelper;
    public static ArrayList<class_304> keybinds = new ArrayList<>();
    public static final String MODID = "bazaarutils";
    public static final String MOD_NAME = "Bazaar Utils";
    public static boolean updatedMajorVersion = false;
    @Getter
    private static String updateNotes;
    public static ScheduledExecutorService BUExecutorService = Executors.newSingleThreadScheduledExecutor();

    public static class_9331<String> CUSTOM_SIZE_COMPONENT;
    public static class_9331<Boolean> CUSTOM_SHOWPRICECHART_COMPONENT;


    @Override
    public void onInitializeClient() {
        registerDataComponents();

        BUConfig.HANDLER.load();

        BUCompatibilityHelper.initializePatches();

        getModProperties();
        registerEventBus();
        subscribeEvents();
        registerCommands();
        registerKeybinds();
        setDefaultValues();
    }

    private static void registerDataComponents() {
        CUSTOM_SIZE_COMPONENT = class_2378.method_10230(
                class_7923.field_49658,
                class_2960.method_60655(BazaarUtils.MODID, "custom_size"),
                class_9331.<String>method_57873().method_57881(Codec.STRING).method_57880()
        );
        CUSTOM_SHOWPRICECHART_COMPONENT = class_2378.method_10230(
                class_7923.field_49658,
                class_2960.method_60655(BazaarUtils.MODID, "has_price_chart"),
                class_9331.<Boolean>method_57873().method_57881(Codec.BOOL).method_57880()
        );
    }

    //uses orbit for custom events
    private void registerEventBus() {
        EVENT_BUS.registerLambdaFactory("com.github.mkram17.bazaarutils", (lookupInMethod, klass) ->
                (MethodHandles.Lookup) lookupInMethod.invoke(null, klass, MethodHandles.lookup()));
    }

    public static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            BUCommands.register(dispatcher);
        });
    }

    //must be run after config load
    private void subscribeEvents(){
        for(BUListener listener : BUListener.getEventListeners()) {
            listener.subscribe();
        }
    }

    private void registerKeybinds(){
        if(!BUCompatibilityHelper.isAmecsReborn())
            return;
        stashHelper = new StashHelper();
        stashHelper.registerTickCounter();
        keybinds.add(stashHelper);

        for(class_304 keybind : keybinds) {
            if(keybind instanceof AmecsKeyBinding)
                KeyBindingHelper.registerKeyBinding(keybind);
        }
    }

    private void setDefaultValues(){
        //causes errors if done as default in config bc constructor uses other config info which isnt loaded yet
        if(BUConfig.get().bookmarks.isEmpty()) {
            BUConfig.get().bookmarks.add(new Bookmark("Diamond")); // Default
        }


    }
    private void getModProperties(){
        FabricLoader.getInstance().getModContainer(MODID).ifPresent(modContainer -> {
            ModMetadata metadata = modContainer.getMetadata();

            CustomValue updateNotesValue = metadata.getCustomValue("latestMajorUpdateNotes");
            if (updateNotesValue != null)
                updateNotes = updateNotesValue.getAsString();

            var oldVersion = BUConfig.get().MOD_VERSION;
            var currentVersion = metadata.getVersion().getFriendlyString();

            var oldVersionMajor = oldVersion.substring(oldVersion.indexOf(".")+1);
            var currentVersionMajor = currentVersion.substring(currentVersion.indexOf(".")+1);

            BUConfig.get().MOD_VERSION = currentVersion;
            Util.scheduleConfigSave();

            if(!oldVersionMajor.equals(currentVersionMajor))
                updatedMajorVersion = true;
        });
    }
}