package com.github.mkram17.bazaarutils.events;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.Util;
import lombok.Getter;
import meteordevelopment.orbit.ICancellable;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_476;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ChestLoadedEvent {
    @Getter
    private class_1263 lowerChestInventory;
    @Getter
    private List<class_1799> itemStacks = new ArrayList<>();
    @Getter
    private String containerName;

    @RunOnInit
    public static void registerScreenEvent() {
        ScreenEvents.AFTER_INIT.register((client, screen, width, height) -> {
            if (screen instanceof class_476 genericContainerScreen) {
                // Use an AtomicInteger for mutable integer in lambda
                final AtomicInteger attempts = new AtomicInteger(0);
                final int MAX_ATTEMPTS = 50; // ~2.5 seconds timeout (50 * 1 tick)

                // Define the check as a Runnable
                Runnable checkGuiLoaded = new Runnable() {
                    @Override
                    public void run() {
                        // Ensure we are still on the same screen
                        if (client.field_1755 != genericContainerScreen) {
                            return;
                        }

                        class_1703 handler = genericContainerScreen.method_17577();
                        if (handler instanceof class_1707 containerHandler) {
                            class_1263 inv = containerHandler.method_7629();
                            // Check if inventory is populated and not in a loading state
                            if (!inv.method_5442() && !inv.method_5438(inv.method_5439() - 1).method_7960() && !isItemLoading(inv)) {
                                // GUI is loaded, post the event
                                ChestLoadedEvent event = new ChestLoadedEvent();
                                event.lowerChestInventory = inv;
                                event.containerName = ScreenInfo.getCurrentScreenInfo().getContainerName();
                                event.itemStacks = getChestItemSlots(inv);
                                BazaarUtils.EVENT_BUS.post(event);
                            } else if (attempts.getAndIncrement() < MAX_ATTEMPTS) {
                                // GUI not loaded, schedule the check for the next tick
                                Util.tickExecuteLater(1, this);
                            }
                        }
                    }
                };
                // Schedule the first check
                Util.tickExecuteLater(1, checkGuiLoaded);
            }
        });
    }

    private static List<class_1799> getChestItemSlots(class_1263 inventory) {
        List<class_1799> stacks = new ArrayList<>();
        for (int i = 0; i < inventory.method_5439(); i++) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_7960()) {
                stacks.add(stack);
            }
        }
        return stacks;
    }

    private static boolean isItemLoading(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); i++) {
            class_1799 item = inventory.method_5438(i);
            if (item.method_7960()) continue;

            class_2561 customName = item.method_58694(class_9334.field_49631);
            if (customName != null) {
                String displayName = Util.removeFormatting(customName.getString());
                if (displayName.contains("Loading")) {
                    PlayerActionUtil.notifyAll("Loading item...", Util.notificationTypes.GUI);
                    return true;
                }
            }
        }
        return false;
    }
}
