package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.events.ReplaceItemEvent;
import com.github.mkram17.bazaarutils.events.SignOpenEvent;
import com.github.mkram17.bazaarutils.events.SlotClickEvent;
import com.github.mkram17.bazaarutils.misc.CustomItemButton;
import com.github.mkram17.bazaarutils.utils.GUIUtils;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.SoundUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_9334;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.github.mkram17.bazaarutils.BazaarUtils.EVENT_BUS;

//TODO low priority -- add number formating with commas (NumberFormat class?) for the tooltips to make large numbers easier to read
//TODO find new name for this
@NoArgsConstructor
public class CustomOrder extends CustomItemButton implements BUListener {
    public static final Map<Integer, class_1792> COLORMAP = new HashMap<>(Map.of(0, class_1802.field_8739, 1, class_1802.field_8747, 2, class_1802.field_8761, 3, class_1802.field_8157, 4, class_1802.field_8157));
    private boolean buySignClicked = false;

    @Getter @Setter
    private boolean enabled;
    @Getter @Setter
    private int orderAmount;
    @Getter
    private class_1792 item;

    public CustomOrder(boolean enabled, int orderAmount, int slotNumber, class_1792 item) {
        this.enabled = enabled;
        this.orderAmount = orderAmount;
        this.slotNumber = slotNumber;
        this.item = item;
        EVENT_BUS.subscribe(this);
    }
    protected CustomOrder(boolean enabled) {
        this.enabled = enabled;
        this.orderAmount = 71680;
        this.slotNumber = 17;
        this.item = class_1802.field_8739;
    }
    public static class_1792 getNextColoredPane(){
        int size = BUConfig.get().customOrders.size();
        return CustomOrder.COLORMAP.get(size % 5);
    }

    public static ConfigCategory.Builder createOrdersCategory(){
        return ConfigCategory.createBuilder()
                .name(class_2561.method_43470("Buy Amount Options"));
    }

    @EventHandler
    public void replaceItemEvent(ReplaceItemEvent event) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        if (!screenInfo.inMenu(ScreenInfo.BazaarMenuType.BUY_ORDER, ScreenInfo.BazaarMenuType.INSTA_BUY) || !isEnabled())
            return;

        if (event.getSlotId() != slotNumber)
            return;

        class_1799 itemStack = new class_1799(getItem(), 1);
        itemStack.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, String.valueOf(getOrderAmount()));

        itemStack.method_57379(class_9334.field_49631, class_2561.method_43470("Buy " + getOrderAmount()).formatted(class_124.field_1064));
        event.setReplacement(itemStack);
    }

    @EventHandler
    public void onSlotClicked(SlotClickEvent event) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        if (!screenInfo.inMenu(ScreenInfo.BazaarMenuType.BUY_ORDER, ScreenInfo.BazaarMenuType.INSTA_BUY) || !isEnabled())
            return;

        if (event.slot.method_34266() != slotNumber)
            return;
        SoundUtil.playSound(BUTTON_SOUND, BUTTON_VOLUME);

        openSign();
    }

    @EventHandler
    private void onSignOpened(SignOpenEvent event) {
        if (!buySignClicked) return;
        GUIUtils.setSignText(Integer.toString(getOrderAmount()), true);
        buySignClicked = false;
    }

    public void openSign() {
        int signSlotId = 16;
        GUIUtils.clickSlot(signSlotId, 0);
        buySignClicked = true;
    }

    public Option<Boolean> createOption() {
        return super.createOption(
                "Buy " + getOrderAmount() + " Button",
                "Buy order button for " + getOrderAmount() + " of an item.",
                this::isEnabled,
                this::setEnabled
        );
    }
    public static void buildOptions(OptionGroup.Builder builder){
        List<CustomOrder> customOrders = BUConfig.get().customOrders;
        if(customOrders.isEmpty())
            customOrders.add(new CustomOrder(true, 71680, 17, CustomOrder.COLORMAP.get(0)));

        for (CustomOrder order : customOrders) {
            builder.option(order.createOption());
        }
    }

    public void remove(){
        if (BUConfig.get().customOrders.contains(this)) {
            BUConfig.get().customOrders.remove(this);
            Util.scheduleConfigSave();
            EVENT_BUS.unsubscribe(this);
        }
    }

    @Override
    public void subscribe() {
        EVENT_BUS.subscribe(this);
    }
}