package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import lombok.Getter;
import lombok.Setter;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_465;
import java.util.List;

//drawing done in MixinHandledScreen
public class OrderStatusHighlight implements BUListener {
    @Getter @Setter
    private boolean enabled;
    public static final class_2960 IDENTIFIER = class_2960.method_43902("bazaarutils", "orderstatushighlight/background");
    public static final float BACKGROUND_TRANSPARENCY = 0.9f;

    public OrderStatusHighlight(boolean enabled){
        this.enabled = enabled;
    }

    private static List<BazaarOrder> getHighlightedOrders() {
        return BUConfig.get().userOrders.stream()
                .filter(order -> order.getItemInfo() != null
                        && order.getItemInfo().slotIndex() != null
                        && order.getFillStatus() == BazaarOrder.Statuses.SET)
                .toList();
    }

    public static BazaarOrder getHighlightedOrder(int slotIndex) {
        return getHighlightedOrders().stream()
                .filter(order -> order.getItemInfo().slotIndex() == slotIndex)
                .findFirst()
                .orElse(null);
    }

    @Override
    public void subscribe() {
//        registerScreenRenderEvents();
        registerTooltipListener();
    }

    public Option<Boolean> createOption() {
        return Option.<Boolean>createBuilder()
                .name(class_2561.method_43470("Order Status Highlight"))
                .description(OptionDescription.of(class_2561.method_43470("Adds a colored background and tooltip for orders that are competitive, matched or outbid in the orders gui inside the bazaar. For outdated orders, also adds the market price in the tooltip.")))
                .binding(false,
                        this::isEnabled,
                        this::setEnabled)
                .controller(BUConfigGui::createBooleanController)
                .build();
    }

    //maybe could be split into separate methods, but this is fine for now
    private void registerTooltipListener() {
        ItemTooltipCallback.EVENT.register((class_1799 stack, net.minecraft.class_1792.class_9635 context, class_1836 type, List<class_2561> lines) -> {
            if (!enabled) return;
            ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
            if (stack == null || stack.method_7960() || stack.method_7909().method_63680().getString().contains("GLASS_PANE") || !screenInfo.inMenu(ScreenInfo.BazaarMenuType.ORDER_SCREEN)) {
                return;
            }

            class_310 client = class_310.method_1551();
            if (client.field_1724 == null || !(client.field_1755 instanceof class_465<?> handledScreen)) {
                return;
            }

            for (class_2561 line : lines) {
                String lineText = line.getString();
                if (lineText.contains("FILLED") || lineText.contains("OUTBID") ||
                        lineText.contains("COMPETITIVE") || lineText.contains("MATCHED")) {
                    // the tooltip is already present, skip processing
                    return;
                }
            }

            int index = -1;
            for (class_1735 slot : handledScreen.method_17577().field_7761) {
                if (!slot.method_7681() || !(slot.method_7677() == stack))
                    continue;
                index = slot.method_34266();
            }

            if(index == -1)
                return;

            BazaarOrder order = getHighlightedOrder(index);
            if (order == null) {
                return;
            }

            OrderInfoContainer.Statuses orderStatus = order.getOutbidStatus();
            if(orderStatus == null) return;

            switch (orderStatus) {
                case OUTBID:
                    lines.add(1, class_2561.method_43470("OUTBID").method_27695(class_124.field_1061, class_124.field_1067));
                    lines.add(2, class_2561.method_43470("Market Price: " + Util.getPrettyString(order.getMarketPrice(order.getPriceType()))).formatted(class_124.field_1061));
                    break;
                case COMPETITIVE:
                    lines.add(1, class_2561.method_43470("COMPETITIVE").method_27695(class_124.field_1060, class_124.field_1067));
                    break;
                case MATCHED:
                    lines.add(1, class_2561.method_43470("MATCHED").method_27695(class_124.field_1054, class_124.field_1067));
                    break;
            }
            if(BUConfig.get().developerMode) {
                var sellPrice = order.getMarketPrice(PriceInfoContainer.PriceType.INSTASELL);
                var buyPrice = order.getMarketPrice(PriceInfoContainer.PriceType.INSTABUY);
                if(sellPrice == null || buyPrice == null)
                    return;

                lines.add(class_2561.method_43470("[BU] Buy: " + Util.getPrettyString(sellPrice) + " coins"));
                lines.add(class_2561.method_43470("[BU] Sell: " + Util.getPrettyString(buyPrice) + " coins"));
            }
        });
    }
}
