package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.config.BUConfig;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

//TODO change the message number instead of sending more
public class OutbidOrderHandler {

    @Getter @Setter
    private boolean autoOpenEnabled;
    @Getter @Setter
    private boolean notifyOutbid;
    @Getter @Setter
    private boolean notificationSound;

    public OutbidOrderHandler(boolean autoOpenEnabled, boolean notifyOutbid) {
        this.autoOpenEnabled = autoOpenEnabled;
        this.notifyOutbid = notifyOutbid;
        this.notificationSound = true;
    }

    public static class_5250 getOutbidMessage(BazaarOrder order) {
        return createYourOrderForText(order)
                .method_10852(class_2561.method_43470(" is now outdated.").method_27692(class_124.field_1068))
                .method_10852(class_2561.method_43470(" Click to open bazaar orders").method_27692(class_124.field_1065));
    }
    public static class_5250 getCompetitiveMessage(BazaarOrder order) {
        return createYourOrderForText(order)
                .method_10852(class_2561.method_43470(" is no longer outdated.").method_27692(class_124.field_1064));
    }
    public static class_5250 getMatchedMessage(BazaarOrder order) {
        return createYourOrderForText(order)
                .method_10852(class_2561.method_43470(" has been matched.").method_27692(class_124.field_1054));
    }
    private static class_5250 createYourOrderForText(BazaarOrder order){
        return class_2561.method_43470("Your " + order.getPriceType().getString().toLowerCase() + " order for ").formatted(class_124.field_1068)
                .append(class_2561.method_43470(order.getVolume().toString() + " ").formatted(class_124.field_1064))
                .append(class_2561.method_43470(order.getName()).formatted(class_124.field_1065));
    }

    public static List<BazaarOrder> getOutbidOrders() {
        return BUConfig.get().userOrders.stream()
                .filter(order -> order.getOutbidStatus() == OrderInfoContainer.Statuses.OUTBID && order.getFillStatus() != OrderInfoContainer.Statuses.FILLED)
                .toList();
    }

    public Collection<Option<Boolean>> createOptions() {
        ArrayList<Option<Boolean>> options = new ArrayList<>();
        options.add(Option.<Boolean>createBuilder()
                .name(class_2561.method_43470("Open Bazaar on Outbid Orders"))
                .description(OptionDescription.of(class_2561.method_43470("Automatically open the bazaar after a delay when an order becomes outdated.")))
                .binding(false,
                        this::isAutoOpenEnabled,
                        this::setAutoOpenEnabled)
                .controller(BUConfigGui::createBooleanController)
                .build());
        options.add(Option.<Boolean>createBuilder()
                .name(class_2561.method_43470("Chat Notification on Outbid Orders"))
                .description(OptionDescription.of(class_2561.method_43470("Sends a message in chat when someone has undercut your order.")))
                .binding(true,
                        this::isNotifyOutbid,
                        this::setNotifyOutbid)
                .controller(BUConfigGui::createBooleanController)
                .build());
        options.add(Option.<Boolean>createBuilder()
                .name(class_2561.method_43470("Sound on Outbid Order"))
                .description(OptionDescription.of(class_2561.method_43470("Plays three short notification sounds when your order becomes outdated.")))
                .binding(true,
                        this::isNotificationSound,
                        this::setNotificationSound)
                .controller(BUConfigGui::createBooleanController)
                .build());
        return options;
    }
}
