package com.github.mkram17.bazaarutils.misc.adapters;

import com.github.mkram17.bazaarutils.utils.Util;
import com.google.gson.*;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import net.minecraft.class_1799;

public class ItemStackCodecGsonAdapter implements JsonSerializer<class_1799>, JsonDeserializer<class_1799> {

    @Override
    public JsonElement serialize(class_1799 stack, Type typeOfSrc, JsonSerializationContext context) {
        if (stack == null || stack.method_7960()) {
            return JsonNull.INSTANCE;
        }

        DataResult<JsonElement> result = class_1799.field_24671.encodeStart(JsonOps.INSTANCE, stack);

        return result.resultOrPartial(errorMessage -> {
                    Util.notifyError("Failed to serialize ItemStack to JSON: " + errorMessage + " - Stack: " + stack, new Throwable());
                })
                .orElse(JsonNull.INSTANCE);
    }

    @Override
    public class_1799 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json == null || json.isJsonNull()) {
            return class_1799.field_8037;
        }

        DataResult<class_1799> result = class_1799.field_24671.parse(JsonOps.INSTANCE, json);

        return result.resultOrPartial(errorMessage -> {
                    Util.notifyError("Failed to deserialize ItemStack from JSON: " + errorMessage + " - JSON: " + json.toString(), new Throwable());
                })
                .orElse(class_1799.field_8037);
    }
}
