package com.github.mkram17.bazaarutils.mixin;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.events.ScreenChangeEvent;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

//for ScreenChangeEvent
@Mixin(value = class_310.class)
public class MinecraftClientMixin {
    @Shadow
    @Nullable
    public class_437 currentScreen;

    @Inject(method = "setScreen", at = @At("HEAD"))
    public void bazaarutilsSetScreen(class_437 newScreen, CallbackInfo ci) {
        BazaarUtils.EVENT_BUS.post(new ScreenChangeEvent(currentScreen, newScreen));
    }
}
