package com.github.mkram17.bazaarutils.mixin;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.events.ReplaceItemEvent;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

//used for ReplaceItemEvent
@Mixin(class_1277.class)
public abstract class MixinSimpleInventory {
    @Final
    @Shadow
    public class_2371<class_1799> heldStacks;


    @Inject(method = "getStack(I)Lnet/minecraft/item/ItemStack;",at = @At("HEAD"), cancellable = true)
    private void onGetStack(int slot, CallbackInfoReturnable<class_1799> cir) {
        if (slot < 0 || slot >= this.heldStacks.size()) return;

        ReplaceItemEvent event = new ReplaceItemEvent(this.heldStacks.get(slot),(class_1277) (Object) this,slot);
        BazaarUtils.EVENT_BUS.post(event);
//        Util.notifyAll("Replace Item Event posted!");
        if (event.getReplacement() != event.getOriginal()) {
            cir.setReturnValue(event.getReplacement());
        }
    }
}