/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.config;

import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.features.BazaarOpenOrdersButton;
import com.github.mkram17.bazaarutils.features.BazaarSettingsButton;
import com.github.mkram17.bazaarutils.features.Bookmark;
import com.github.mkram17.bazaarutils.features.CustomOrder;
import com.github.mkram17.bazaarutils.features.FlipHelper;
import com.github.mkram17.bazaarutils.features.MaxBuyOrder;
import com.github.mkram17.bazaarutils.features.OrderLimit;
import com.github.mkram17.bazaarutils.features.OrderStatusHighlight;
import com.github.mkram17.bazaarutils.features.OutbidOrderHandler;
import com.github.mkram17.bazaarutils.features.PriceCharts;
import com.github.mkram17.bazaarutils.features.StashMessages;
import com.github.mkram17.bazaarutils.features.restrictsell.RestrictSell;
import com.github.mkram17.bazaarutils.features.restrictsell.RestrictSellControl;
import com.github.mkram17.bazaarutils.misc.adapters.ItemStackCodecGsonAdapter;
import com.github.mkram17.bazaarutils.misc.adapters.ZonedDateTimeAdapter;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.utils.Util;
import com.google.gson.typeadapters.RuntimeTypeAdapterFactory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.lang.reflect.Field;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;

public class BUConfig {
    public static RuntimeTypeAdapterFactory<CustomOrder> customOrderAdapterFactory = RuntimeTypeAdapterFactory.of(CustomOrder.class).registerSubtype(MaxBuyOrder.class).registerSubtype(CustomOrder.class);
    public static final ConfigClassHandler<BUConfig> HANDLER = ConfigClassHandler.createBuilder(BUConfig.class).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("bazaarutils.json")).appendGsonBuilder(gsonBuilder -> gsonBuilder.registerTypeAdapter(class_1799.class, (Object)new ItemStackCodecGsonAdapter()).registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).registerTypeAdapterFactory(customOrderAdapterFactory)).build()).build();
    @SerialEntry
    public String MOD_VERSION = "";
    @SerialEntry
    public boolean firstLoad = true;
    @SerialEntry
    public String resourcesSha = "";
    @SerialEntry
    public FlipHelper flipHelper = new FlipHelper(true, 17);
    @SerialEntry
    public List<BazaarOrder> userOrders = new CopyOnWriteArrayList<BazaarOrder>();
    @SerialEntry
    public double bzTax = 1.125;
    @SerialEntry
    public ArrayList<CustomOrder> customOrders = new ArrayList<MaxBuyOrder>(List.of(new MaxBuyOrder(true)));
    @SerialEntry
    public boolean developerMode = false;
    @SerialEntry
    public OutbidOrderHandler outbidOrderHandler = new OutbidOrderHandler(false, true);
    @SerialEntry
    public RestrictSell restrictSell = new RestrictSell(true, 3, new ArrayList<RestrictSellControl>(List.of(new RestrictSellControl(RestrictSell.restrictBy.PRICE, 1000000.0))));
    @SerialEntry
    public Developer developer = new Developer();
    @SerialEntry
    public StashMessages stashMessages = new StashMessages(false);
    @SerialEntry
    public ArrayList<Bookmark> bookmarks = new ArrayList();
    @SerialEntry
    public PriceCharts priceCharts = new PriceCharts();
    @SerialEntry
    public OrderStatusHighlight orderStatusHighlight = new OrderStatusHighlight(true);
    @SerialEntry
    public boolean disableErrorNotifications = false;
    @SerialEntry
    public boolean orderFilledSound = true;
    @SerialEntry
    public OrderLimit orderLimit = new OrderLimit(true, 1.5E10);
    @SerialEntry
    public BazaarOpenOrdersButton bazaarOpenOrdersButton = new BazaarOpenOrdersButton(true);

    public static BUConfig get() {
        return (BUConfig)HANDLER.instance();
    }

    public static void openGUI() {
        class_310 client = class_310.method_1551();
        client.method_63588(() -> client.method_1507(BUConfigGui.create(null, BUConfig.get())));
    }

    public class_437 createGUI(class_437 parent) {
        return BUConfigGui.create(parent, this);
    }

    public List<BUListener> getSerializedEvents() {
        ArrayList<BUListener> events = new ArrayList<BUListener>();
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(this);
                if (value instanceof BUListener) {
                    events.add((BUListener)value);
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                for (Object item : (Collection)value) {
                    if (!(item instanceof BUListener)) continue;
                    events.add((BUListener)item);
                }
            }
            catch (IllegalAccessException e) {
                Util.notifyError("Error accessing field: " + field.getName() + " - " + e.getMessage(), e);
            }
        }
        return events;
    }

    public static List<class_339> getWidgets() {
        ArrayList<class_339> widgets = new ArrayList<class_339>();
        widgets.addAll(BazaarOpenOrdersButton.getWidget());
        widgets.addAll(BazaarSettingsButton.getWidget());
        widgets.addAll(Bookmark.getWidgets());
        widgets.addAll(OrderLimit.getWidget());
        return widgets;
    }

    @Generated
    public boolean isDisableErrorNotifications() {
        return this.disableErrorNotifications;
    }

    @Generated
    public void setDisableErrorNotifications(boolean disableErrorNotifications) {
        this.disableErrorNotifications = disableErrorNotifications;
    }

    @Generated
    public boolean isOrderFilledSound() {
        return this.orderFilledSound;
    }

    @Generated
    public void setOrderFilledSound(boolean orderFilledSound) {
        this.orderFilledSound = orderFilledSound;
    }

    public static class Developer {
        public boolean allMessages = false;
        public boolean errorMessages = false;
        public boolean guiMessages = false;
        public boolean featureMessages = false;
        public boolean bazaarDataMessages = false;
        public boolean commandMessages = false;
        public boolean itemDataMessages = false;

        public Collection<? extends Option<?>> createOptions() {
            ArrayList<Option> optionList = new ArrayList<Option>();
            optionList.add(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Error Messages")).binding((Object)this.errorMessages, () -> this.errorMessages, newVal -> {
                this.errorMessages = newVal;
            }).controller(BUConfigGui::createBooleanController).build());
            optionList.add(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"GUI Messages")).binding((Object)this.guiMessages, () -> this.guiMessages, newVal -> {
                this.guiMessages = newVal;
            }).controller(BUConfigGui::createBooleanController).build());
            optionList.add(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Feature Messages")).binding((Object)this.featureMessages, () -> this.featureMessages, newVal -> {
                this.featureMessages = newVal;
            }).controller(BUConfigGui::createBooleanController).build());
            optionList.add(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Bazaar Data Messages")).binding((Object)this.bazaarDataMessages, () -> this.bazaarDataMessages, newVal -> {
                this.bazaarDataMessages = newVal;
            }).controller(BUConfigGui::createBooleanController).build());
            optionList.add(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Command Messages")).binding((Object)this.commandMessages, () -> this.commandMessages, newVal -> {
                this.commandMessages = newVal;
            }).controller(BUConfigGui::createBooleanController).build());
            optionList.add(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Item Data Messages")).binding((Object)this.itemDataMessages, () -> this.itemDataMessages, newVal -> {
                this.itemDataMessages = newVal;
            }).controller(BUConfigGui::createBooleanController).build());
            return optionList;
        }

        public boolean isDeveloperVariableEnabled(Util.notificationTypes type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case Util.notificationTypes.GUI -> this.guiMessages;
                case Util.notificationTypes.FEATURE -> this.featureMessages;
                case Util.notificationTypes.BAZAARDATA -> this.bazaarDataMessages;
                case Util.notificationTypes.COMMAND -> this.commandMessages;
                case Util.notificationTypes.ORDERDATA -> this.itemDataMessages;
            };
        }
    }
}

