/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.misc.BUCompatibilityHelper;
import com.github.mkram17.bazaarutils.misc.autoregistration.RegisterWidget;
import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import com.github.mkram17.bazaarutils.misc.widgets.ItemSlotButtonWidget;
import com.github.mkram17.bazaarutils.misc.widgets.TextDisplayWidget;
import com.github.mkram17.bazaarutils.mixin.AccessorHandledScreen;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.TimeUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.DoubleFieldControllerBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class OrderLimit
implements BUListener {
    private boolean enabled;
    private double coinLimit;
    private final List<OrderLimitEntry> orderLimitEntries;

    private double getTotalOrderedCoins() {
        return this.orderLimitEntries.stream().mapToDouble(OrderLimitEntry::price).sum();
    }

    public OrderLimit(boolean enabled, double coinLimit) {
        this.enabled = enabled;
        this.coinLimit = coinLimit;
        this.orderLimitEntries = new ArrayList<OrderLimitEntry>();
    }

    @RunOnInit
    public static void registerBazaarOpen() {
        ScreenEvents.AFTER_INIT.register((client, screen, width, height) -> {
            ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
            if (screenInfo == null || !screenInfo.inBazaar()) {
                return;
            }
            BUConfig.get().orderLimit.removeOldEntries();
        });
    }

    public void removeOldEntries() {
        this.orderLimitEntries.stream().filter(entry -> entry.time().isBefore(TimeUtil.LAST_BAZAAR_LIMIT_RESET_TIME)).toList().forEach(this.orderLimitEntries::remove);
    }

    public static String formatNumberWithPrefix(double number) {
        double value;
        String prefix;
        if (number >= 1.0E9) {
            prefix = "B";
            value = number / 1.0E9;
        } else {
            prefix = "M";
            value = number / 1000000.0;
        }
        return String.format("%.2f", value) + prefix;
    }

    public void addOrderToLimit(double price) {
        this.orderLimitEntries.add(new OrderLimitEntry(price, ZonedDateTime.now()));
    }

    @RegisterWidget
    public static List<class_339> getWidget() {
        class_437 class_4372;
        OrderLimit orderLimit = BUConfig.get().orderLimit;
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        boolean isTargetScreen = screenInfo.inBazaar();
        if (!(orderLimit.isEnabled() && isTargetScreen && (class_4372 = class_310.method_1551().field_1755) instanceof AccessorHandledScreen)) {
            return Collections.emptyList();
        }
        AccessorHandledScreen screen = (AccessorHandledScreen)class_4372;
        String screenTitle = class_310.method_1551().field_1755.method_25440().getString();
        String orderedCoinsFormatted = OrderLimit.formatNumberWithPrefix(orderLimit.getTotalOrderedCoins());
        class_5250 orderedCoinsText = orderLimit.getTotalOrderedCoins() >= orderLimit.getCoinLimit() ? class_2561.method_43470((String)orderedCoinsFormatted).method_27692(class_124.field_1061) : class_2561.method_43470((String)orderedCoinsFormatted).method_27692(class_124.field_1060);
        class_5250 limitText = class_2561.method_43470((String)("/" + OrderLimit.formatNumberWithPrefix(orderLimit.getCoinLimit()))).method_27692(class_124.field_1065);
        class_5250 message = class_2561.method_43470((String)"Bazaar Order Limit: ").method_27692(class_124.field_1065).method_10852((class_2561)orderedCoinsText).method_10852((class_2561)limitText);
        ItemSlotButtonWidget.ScreenWidgetDimensions dimensions = ItemSlotButtonWidget.getSafeScreenDimensions(screen, screenTitle);
        int textSizeX = 58;
        int textSizeY = 8;
        int spacing = 5;
        if (BUCompatibilityHelper.isSkyblockerLoaded()) {
            spacing += 21;
        }
        int buttonX = dimensions.x() + textSizeX;
        int buttonY = dimensions.y() - spacing - textSizeY;
        TextDisplayWidget widget = new TextDisplayWidget(buttonX, buttonY, textSizeX, textSizeY, (class_2561)message);
        return Collections.singletonList(widget);
    }

    @Override
    public void subscribe() {
        BazaarUtils.EVENT_BUS.subscribe((Object)this);
    }

    public OptionGroup buildOrderLimitGroup() {
        OptionGroup.Builder restrictSellGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43470((String)"Order Limit")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Shows you how close you are to the coin order limit for the bazaar. Resets at 12am GMT.")}));
        this.buildOptions(restrictSellGroupBuilder);
        return restrictSellGroupBuilder.build();
    }

    private void buildOptions(OptionGroup.Builder builder) {
        builder.option(this.createEnabledOption());
        builder.option(this.createLimitOption());
    }

    private Option<Boolean> createEnabledOption() {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Show Bazaar Order Limit")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Shows you how close you are to the coin order limit for the bazaar at the top of the bazaar. Resets at 12am GMT.")})).binding((Object)false, this::isEnabled, this::setEnabled).controller(BUConfigGui::createBooleanController).build();
    }

    private Option<Double> createLimitOption() {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Order Limit")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"The order limit you want to display.")})).binding((Object)this.coinLimit, this::getCoinLimit, this::setCoinLimit).controller(DoubleFieldControllerBuilder::create).build();
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public double getCoinLimit() {
        return this.coinLimit;
    }

    @Generated
    public void setCoinLimit(double coinLimit) {
        this.coinLimit = coinLimit;
    }

    @Generated
    public List<OrderLimitEntry> getOrderLimitEntries() {
        return this.orderLimitEntries;
    }

    public record OrderLimitEntry(double price, ZonedDateTime time) {
        public OrderLimitEntry(double price, ZonedDateTime time) {
            this.price = price;
            this.time = time;
            Util.scheduleConfigSave();
        }

        @Generated
        public double getPrice() {
            return this.price;
        }

        @Generated
        public ZonedDateTime getTime() {
            return this.time;
        }
    }
}

