/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.features.restrictsell;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.events.ReplaceItemEvent;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.features.restrictsell.RestrictSellControl;
import com.github.mkram17.bazaarutils.features.restrictsell.SellItem;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class RestrictSell
implements BUListener {
    private boolean enabled;
    private final int safetyClicksRequired;
    private ArrayList<RestrictSellControl> controls;
    private static final int SELL_ITEM_SLOT_ID = 47;
    private boolean locked = false;
    private int safetyClicks = 0;

    public void addSafetyClick() {
        ++this.safetyClicks;
    }

    public void resetSafetyClicks() {
        this.safetyClicks = 0;
    }

    public RestrictSell(boolean enabled, int safetyClicksRequired, ArrayList<RestrictSellControl> controls) {
        this.enabled = enabled;
        this.safetyClicksRequired = safetyClicksRequired;
        this.controls = controls;
    }

    private void registerScreenEvent() {
        ScreenEvents.AFTER_INIT.register((client, screen, width, height) -> {
            this.safetyClicks = 0;
        });
    }

    @EventHandler
    private void onGUI(ReplaceItemEvent e) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        try {
            if (e.getSlotId() != 47 || !screenInfo.inBazaar()) {
                return;
            }
            if (e.getOriginal() == null || e.getOriginal().method_57380().method_57845(class_9334.field_49632) == null) {
                return;
            }
            if (((class_9290)e.getOriginal().method_57380().method_57845(class_9334.field_49632).get()).comp_2401().size() < 6 || ((class_2561)((class_9290)e.getOriginal().method_57380().method_57845(class_9334.field_49632).get()).comp_2401().get(4)).getString().contains("Loading")) {
                return;
            }
            class_1799 sellButton = e.getOriginal().method_7972();
            List changedComponents = ((class_9290)sellButton.method_57380().method_57845(class_9334.field_49632).get()).comp_2401();
            int numItems = this.findNumItems(changedComponents);
            ArrayList<SellItem> items = this.getItems(changedComponents, numItems);
            String coinsText = ((class_2561)changedComponents.get(5 + numItems)).getString();
            if (!coinsText.contains("coins")) {
                return;
            }
            double totalPrice = Double.parseDouble(coinsText.substring(coinsText.indexOf(": ") + 2, coinsText.indexOf(" coins")).replace(",", ""));
            this.locked = this.isInstaSellLocked(items, totalPrice);
            if (this.locked) {
                sellButton = e.getOriginal().method_7972();
                if (this.safetyClicksRequired != this.safetyClicks) {
                    sellButton.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, (Object)String.valueOf(this.safetyClicksRequired - this.safetyClicks));
                }
            }
            e.setReplacement(sellButton);
        }
        catch (Exception ex) {
            Util.notifyError("Error parsing sell item components", ex);
        }
    }

    private int findNumItems(List<class_2561> changedComponents) {
        if (Util.findComponentWith(changedComponents, "Some items can't be sold") == null) {
            return changedComponents.size() - 8;
        }
        return changedComponents.size() - 10;
    }

    public ArrayList<SellItem> getItems(List<class_2561> changedComponents, int numItems) {
        ArrayList<SellItem> items = new ArrayList<SellItem>();
        try {
            for (int i = 4; i < 4 + numItems; ++i) {
                if (i >= changedComponents.size()) {
                    Util.notifyError("Component index " + i + " out of bounds. Total components: " + changedComponents.size(), new Throwable("Restrict Sell Error"));
                    break;
                }
                List components = changedComponents.get(i).method_10855();
                if (components.isEmpty()) continue;
                if (components.size() < 2) {
                    Util.notifyError("Not enough components to find item volume. Size: " + components.size() + " at index " + i, new Throwable("Restrict Sell Error"));
                    continue;
                }
                int indexOfVolume = Util.componentIndexOf(components, "x") - 1;
                if (indexOfVolume < 0) continue;
                int volume = Integer.parseInt(((class_2561)components.get(indexOfVolume)).getString().replace(",", ""));
                if (components.size() > 3) {
                    String name = ((class_2561)components.get(3)).getString().trim();
                    SellItem newItem = new SellItem(volume, name);
                    items.add(newItem);
                    continue;
                }
                Util.notifyError("Not enough components to find item name. Size: " + components.size() + " at index " + i, new Throwable("Restrict Sell Error"));
            }
        }
        catch (Exception e) {
            Util.notifyError("Error parsing sell item components. NumItems: " + numItems + ", Components size: " + changedComponents.size(), e);
        }
        return items;
    }

    public boolean isSlotLocked(int slotId) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        return screenInfo.inBazaar() && slotId == 47 && this.locked;
    }

    private boolean isInstaSellLocked(ArrayList<SellItem> items, double totalPrice) {
        return this.isSellingRestrictedIndividualItem(items) || this.isSellingRestrictedTotalPrice(totalPrice);
    }

    private boolean isSellingRestrictedTotalPrice(double totalPrice) {
        for (RestrictSellControl control : this.controls) {
            if (!control.isEnabled() || control.getRule() != restrictBy.PRICE || !(totalPrice > control.getAmount())) continue;
            return true;
        }
        return false;
    }

    private boolean isSellingRestrictedIndividualItem(ArrayList<SellItem> items) {
        for (SellItem item : items) {
            if (!this.isSellingItemRestricted(item.volume(), item.name())) continue;
            return true;
        }
        return false;
    }

    private boolean isSellingItemRestricted(int volume, String name) {
        for (RestrictSellControl control : this.controls) {
            if (!control.isEnabled()) continue;
            if (control.getRule() == restrictBy.VOLUME && (double)volume > control.getAmount()) {
                return true;
            }
            if (control.getRule() != restrictBy.NAME || !name.equalsIgnoreCase(control.getName())) continue;
            return true;
        }
        return false;
    }

    public void addRule(restrictBy newRule, double limit) {
        this.controls.add(new RestrictSellControl(newRule, limit));
    }

    public void addRule(restrictBy newRule, String name) {
        this.controls.add(new RestrictSellControl(newRule, name));
    }

    public String getMessage() {
        StringBuilder message = new StringBuilder("Sell protected by rules:");
        for (RestrictSellControl control : this.controls) {
            if (!control.isEnabled()) continue;
            if (control.getRule() == restrictBy.PRICE) {
                message.append(" PRICE: ");
            } else if (control.getRule() == restrictBy.VOLUME) {
                message.append(" VOLUME: ");
            } else {
                message.append(" NAME: ");
                message.append(control.getName());
                continue;
            }
            message.append(control.getAmount());
        }
        message.append(" (Safety Clicks Left: ").append(3 - this.safetyClicks).append(")");
        return message.toString();
    }

    public Option<Boolean> createRuleOption(RestrictSellControl control) {
        class_5250 descriptionText;
        class_5250 nameText;
        if (control.getRule() == restrictBy.NAME) {
            String itemName = control.getName();
            nameText = class_2561.method_43470((String)("Item: " + itemName));
            descriptionText = class_2561.method_43470((String)("Block insta-sell for item: " + itemName));
        } else {
            double amount = control.getAmount();
            String typeText = control.getRule() == restrictBy.VOLUME ? "Volume < " : "Price < ";
            nameText = class_2561.method_43470((String)(typeText + amount));
            String desc = control.getRule() == restrictBy.PRICE ? "Block insta-sell if price exceeds " + amount : "Block insta-sell if volume exceeds " + amount;
            descriptionText = class_2561.method_43470((String)desc);
        }
        return Option.createBuilder().name((class_2561)nameText).description(OptionDescription.of((class_2561[])new class_2561[]{descriptionText})).binding((Object)false, control::isEnabled, control::setEnabled).controller(BUConfigGui::createBooleanController).build();
    }

    public void buildOptions(OptionGroup.Builder builder) {
        for (RestrictSellControl control : this.getControls()) {
            builder.option(this.createRuleOption(control));
        }
    }

    @Override
    public void subscribe() {
        this.registerScreenEvent();
        BazaarUtils.EVENT_BUS.subscribe((Object)this);
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public ArrayList<RestrictSellControl> getControls() {
        return this.controls;
    }

    @Generated
    public void setControls(ArrayList<RestrictSellControl> controls) {
        this.controls = controls;
    }

    @Generated
    public int getSafetyClicks() {
        return this.safetyClicks;
    }

    public static enum restrictBy {
        PRICE,
        VOLUME,
        NAME;

    }
}

