/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.misc.orderinfo;

import com.github.mkram17.bazaarutils.data.BazaarData;
import com.github.mkram17.bazaarutils.utils.Util;
import java.util.OptionalDouble;
import lombok.Generated;

public class PriceInfoContainer {
    protected Double pricePerItem;
    protected PriceType priceType;
    private double instaSellPrice;
    private double instaBuyPrice;

    public PriceInfoContainer(Double pricePerItem, PriceType priceType) {
        this.priceType = priceType;
        if (pricePerItem != null) {
            this.pricePerItem = (double)Math.round(pricePerItem * 10.0) / 10.0;
        }
        if (priceType == null) {
            this.priceType = PriceType.INSTASELL;
        }
    }

    public Double getMarketPrice(PriceType priceType) {
        return switch (priceType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.instaSellPrice;
            case 1 -> this.instaBuyPrice;
        };
    }

    protected void updateMarketPrice(String productId) {
        OptionalDouble instaSellPriceOpt = BazaarData.findItemPriceOptional(productId, PriceType.INSTASELL);
        OptionalDouble instaBuyPriceOpt = BazaarData.findItemPriceOptional(productId, PriceType.INSTABUY);
        instaSellPriceOpt.ifPresentOrElse(price -> {
            this.instaSellPrice = Util.truncateNum(price);
        }, () -> {
            this.instaSellPrice = -1.0;
        });
        instaBuyPriceOpt.ifPresentOrElse(price -> {
            this.instaBuyPrice = Util.truncateNum(price);
        }, () -> {
            this.instaBuyPrice = -1.0;
        });
    }

    public void flipPrices(double newPrice) {
        this.priceType = this.priceType.getOpposite();
        this.pricePerItem = newPrice;
    }

    @Generated
    public void setPricePerItem(Double pricePerItem) {
        this.pricePerItem = pricePerItem;
    }

    @Generated
    public Double getPricePerItem() {
        return this.pricePerItem;
    }

    @Generated
    public void setPriceType(PriceType priceType) {
        this.priceType = priceType;
    }

    @Generated
    public PriceType getPriceType() {
        return this.priceType;
    }

    @Generated
    public double getInstaSellPrice() {
        return this.instaSellPrice;
    }

    @Generated
    public double getInstaBuyPrice() {
        return this.instaBuyPrice;
    }

    @Generated
    public void setInstaBuyPrice(double instaBuyPrice) {
        this.instaBuyPrice = instaBuyPrice;
    }

    public static enum PriceType {
        INSTASELL,
        INSTABUY;

        private PriceType opposite;

        public String getString() {
            return switch (this.ordinal()) {
                case 0 -> "Buy";
                case 1 -> "Sell";
                default -> "Undefined";
            };
        }

        @Generated
        public PriceType getOpposite() {
            return this.opposite;
        }

        static {
            PriceType.INSTASELL.opposite = INSTABUY;
            PriceType.INSTABUY.opposite = INSTASELL;
        }
    }
}

