/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.utils;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.UserOrdersChangeEvent;
import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import meteordevelopment.orbit.ICancellable;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;

public class Util {
    private static boolean configSaveScheduled = false;
    private static final LinkedList<ScheduledTask> tasks = new LinkedList();
    public static final String HELP_MESSAGE = "Commands: /bu or /bazaarutils to open settings gui. \n---------------------------\n /bu tax {amount} to set bazaar tax. This is important for the mod to function correctly. /bu customorders to see current Custom Orders. /bu customorder {order amount} {slot number} to make new Custom Order /bu customorder remove {customorder number} to remove Custom Order (find number by using /bu customorders) \n---------------------------\n  ";
    public static final String DISCORD_LINK = "https://discord.gg/xDKjvm5hQd";
    public static final class_2561 DISCORD_TEXT = class_2561.method_43470((String)"Discord server").method_27694(style -> {
        try {
            return style.method_10982(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10608(new URI(DISCORD_LINK))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to join the Discord!")));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    });
    public static final class_2561 CHANGELOG = class_2561.method_43470((String)"Click To See Changelog").method_27694(style -> {
        try {
            return style.method_10982(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10608(new URI("https://modrinth.com/mod/bazaar-utils/changelog"))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to see the changelog"))).method_27706(class_124.field_1060);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    });

    public static void logMessage(String message) {
        String callingName = Util.getCallingClassName();
        LogManager.getLogger((String)callingName).info("[Bazaar Utils] Message [{}]", (Object)message);
    }

    public static void logError(String message, Throwable e) {
        String callingName = Util.getCallingClassName();
        Util.logError(message, callingName, e);
    }

    private static void logError(String message, String callingName, Throwable e) {
        if (e == null) {
            LogManager.getLogger((String)callingName).error("[Bazaar Utils Error]({}) Developer Message: {}", (Object)callingName, (Object)message);
        } else {
            LogManager.getLogger((String)callingName).error("[Bazaar Utils Error]({}) Developer Message: {}\n Throwable Message {}\n Stacktrace: {}", (Object)callingName, (Object)message, (Object)e.getMessage(), (Object)Arrays.toString(e.getStackTrace()));
        }
    }

    public static void notifyError(String message, Throwable e) {
        String callingName = Util.getCallingClassName();
        String simpleCallingName = callingName.substring(callingName.lastIndexOf(".") + 1);
        class_5250 messageText = class_2561.method_43470((String)("[Bazaar Utils Error]: " + message + ". Click here for support.")).method_27694(style -> {
            try {
                return style.method_10977(class_124.field_1061).method_10958((class_2558)new class_2558.class_10608(new URI(DISCORD_LINK))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to join the Discord for support")));
            }
            catch (URISyntaxException uriSyntaxException) {
                throw new RuntimeException(uriSyntaxException);
            }
        });
        if (!BUConfig.get().disableErrorNotifications) {
            PlayerActionUtil.sendPlayerMessage((class_2561)messageText);
        }
        Util.logError(message, simpleCallingName, e);
    }

    public static void addWatchedOrder(BazaarOrder item) {
        if (item == null) {
            return;
        }
        assert (item.getProductID() != null);
        BUConfig.get().userOrders.add(item);
        PlayerActionUtil.notifyAll("Added item: \u00a7 " + String.valueOf(item), notificationTypes.ORDERDATA);
        BazaarUtils.EVENT_BUS.post((ICancellable)new UserOrdersChangeEvent(UserOrdersChangeEvent.ChangeTypes.ADD, item));
        Util.scheduleConfigSave();
    }

    public static void scheduleConfigSave() {
        if (!configSaveScheduled) {
            configSaveScheduled = true;
            Util.tickExecuteLater(20, () -> {
                BUConfig.HANDLER.save();
                configSaveScheduled = false;
            });
        }
    }

    @RunOnInit
    public static void subscribeTicks() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            LinkedList<Runnable> actionsToRun = new LinkedList<Runnable>();
            LinkedList<ScheduledTask> tasksToRemove = new LinkedList<ScheduledTask>();
            LinkedList<ScheduledTask> linkedList = tasks;
            synchronized (linkedList) {
                for (ScheduledTask task : tasks) {
                    --task.ticksLeft;
                    if (task.ticksLeft > 0) continue;
                    actionsToRun.add(task.action);
                    tasksToRemove.add(task);
                }
                if (!tasksToRemove.isEmpty()) {
                    tasks.removeAll(tasksToRemove);
                }
            }
            for (Runnable action : actionsToRun) {
                try {
                    action.run();
                }
                catch (Exception e) {
                    Util.notifyError("Error executing scheduled task", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tickExecuteLater(int ticks, Runnable action) {
        LinkedList<ScheduledTask> linkedList = tasks;
        synchronized (linkedList) {
            tasks.add(new ScheduledTask(ticks, action));
        }
    }

    public static String getCallingClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > 3) {
            String className = stackTrace[3].getClassName();
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return "UnknownClass";
    }

    public static boolean genericIsSimilarValue(double value1, double value2, double tolerance) {
        return Math.abs(value1 - value2) <= tolerance;
    }

    public static int componentIndexOf(List<class_2561> components, String lookingFor) {
        int num = 0;
        for (class_2561 component : components) {
            if (component.getString().contains(lookingFor)) {
                return num;
            }
            ++num;
        }
        return -1;
    }

    public static int componentLastIndexOf(List<class_2561> components, String lookingFor) {
        for (int i = components.size() - 1; i >= 0; --i) {
            if (!components.get(i).getString().contains(lookingFor)) continue;
            return i;
        }
        return -1;
    }

    public static class_2561 findComponentWith(List<class_2561> components, String lookingFor) {
        for (class_2561 component : components) {
            if (!component.getString().contains(lookingFor)) continue;
            return component;
        }
        return null;
    }

    public static String removeFormatting(String str) {
        return str.replaceAll("\u00a7.", "").replace(",", "").trim();
    }

    public static int parseNumber(String input) {
        input = input.toUpperCase();
        double value = Double.parseDouble(input.replaceAll("[^0-9.]", ""));
        if (input.endsWith("K")) {
            return (int)(value * 1000.0);
        }
        if (input.endsWith("M")) {
            return (int)(value * 1000000.0);
        }
        if (input.endsWith("B")) {
            return (int)(value * 1.0E9);
        }
        return (int)value;
    }

    public static <T> void writeFile(T content) {
        try {
            Files.write(Paths.get("bazaar_data.json", new String[0]), content.toString().getBytes(), new OpenOption[0]);
            PlayerActionUtil.notifyAll("Data written to file successfully.");
        }
        catch (Exception e) {
            System.out.println("Failed to write data to file");
            e.printStackTrace();
        }
    }

    public static String extractTextAfterWord(String text, String word) {
        int endIndex;
        if (text == null || word == null || text.isEmpty() || word.isEmpty()) {
            return "";
        }
        int wordIndex = text.indexOf(word);
        if (wordIndex == -1) {
            return "";
        }
        int startIndex = wordIndex + word.length();
        if (startIndex >= text.length()) {
            return "";
        }
        while (startIndex < text.length() && Character.isWhitespace(text.charAt(startIndex))) {
            ++startIndex;
        }
        if (startIndex >= text.length()) {
            return "";
        }
        for (endIndex = startIndex; endIndex < text.length() && !Character.isWhitespace(text.charAt(endIndex)); ++endIndex) {
        }
        return Util.removeFormatting(text.substring(startIndex, endIndex));
    }

    public static String getPrettyString(double num) {
        return String.format("%,.1f", num);
    }

    public static double truncateNum(double num) {
        return (double)Math.round(num * 10.0) / 10.0;
    }

    public static enum notificationTypes {
        GUI,
        FEATURE,
        BAZAARDATA,
        COMMAND,
        ORDERDATA;


        public boolean isEnabled() {
            return BUConfig.get().developer.isDeveloperVariableEnabled(this);
        }
    }

    private static class ScheduledTask {
        int ticksLeft;
        Runnable action;

        @Generated
        public ScheduledTask(int ticksLeft, Runnable action) {
            this.ticksLeft = ticksLeft;
            this.action = action;
        }
    }
}

