package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.ChestLoadedEvent;
import com.github.mkram17.bazaarutils.events.ReplaceItemEvent;
import com.github.mkram17.bazaarutils.events.SlotClickEvent;
import com.github.mkram17.bazaarutils.misc.CustomItemButton;
import com.github.mkram17.bazaarutils.misc.autoregistration.RegisterWidget;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.misc.widgets.ItemSlotButtonWidget;
import com.github.mkram17.bazaarutils.misc.BUCompatibilityHelper;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.mixin.AccessorHandledScreen;
import com.github.mkram17.bazaarutils.utils.*;
import lombok.Getter;
import lombok.Setter;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_8666;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Bookmark extends CustomItemButton {

    @Getter
    public final String name;
    @Getter @Setter
    public class_1799 bookmarkedItemStack;
    @Getter
    private final OrderInfoContainer orderInfo;
    private static final int SIGN_SLOT_NUMBER = 45;

    private static final class_2960 BASE = class_2960.method_43902(BazaarUtils.MODID, "widget/bookmark_widget_base");
    private static final class_2960 HOVER = class_2960.method_43902(BazaarUtils.MODID, "widget/bookmark_widget_hover");
    public static final class_8666 SLOT_BUTTON_TEXTURES = new class_8666(
            BASE,
            HOVER);

    @EventHandler
    protected void onGuiLoad(ChestLoadedEvent event) {
            BazaarUtils.EVENT_BUS.unsubscribe(this);
    }

    public Bookmark(String name) {
        this.name = name;
        this.slotNumber = 0;
        changeVisuals(isItemBookmarked(this.name));
        this.replacementItem.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, "★");
        this.bookmarkedItemStack = findItemStack(name);
        this.orderInfo = new OrderInfoContainer(name, null, null, PriceInfoContainer.PriceType.INSTABUY, null);

        BazaarUtils.EVENT_BUS.subscribe(this);
    }

    @EventHandler
    protected void replaceItemEvent(ReplaceItemEvent event) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        try {
            //The bookmark can be null if it was a previously added one, not a potential new one
            if (!super.shouldReplaceItem(event) || (bookmarkedItemStack == null && !BUConfig.get().bookmarks.contains(this)))
                return;

            if (replacementItem == null)
                changeVisuals(isItemBookmarked(name));

            event.setReplacement(replacementItem);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    private void onBookmarkClick(SlotClickEvent event){
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        if(!super.shouldUseSlot(event))
            return;
        SoundUtil.playSound(BUTTON_SOUND, BUTTON_VOLUME);
        reverseBookmarkStatus();
        bookmarkedItemStack = findItemStack(name);
        Util.scheduleConfigSave();
    }

    public void onWidgetLeftClick(){
        SoundUtil.playSound(BUTTON_SOUND, BUTTON_VOLUME);
        boolean userHasSkyblockerBazaarOverlay = BUCompatibilityHelper.isSkyblockerBazaarOverlayEnabled();

        if(userHasSkyblockerBazaarOverlay) {
            BUCompatibilityHelper.setSkyblockerBazaarOverlayValue(false);
        }

        GUIUtils.clickSlot(SIGN_SLOT_NUMBER, 0);
        GUIUtils.setSignText(name, true);

        if(userHasSkyblockerBazaarOverlay) {
            Util.tickExecuteLater(10, () -> BUCompatibilityHelper.setSkyblockerBazaarOverlayValue(true));
        }
    }

    public void onWidgetShiftClick(){
        BUConfig.get().bookmarks.remove(this);
        Util.scheduleConfigSave();
    }

    private void reverseBookmarkStatus(){
        if(isItemBookmarked(name)) {
            changeVisuals(false);
            BUConfig.get().bookmarks.remove(this);
        }else {
            changeVisuals(true);
            BUConfig.get().bookmarks.add(this);
        }
        Util.scheduleConfigSave();
    }

    private void changeVisuals(boolean bookmarked){
        if(bookmarked) {
            replacementItem = new class_1799(class_1802.field_8656, 1);
            replacementItem.method_57379(class_9334.field_49631, class_2561.method_43470("Remove " + name + " Bookmark"));
            replacementItem.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, "⃠ ");
        }
        else {
            replacementItem = new class_1799(class_1802.field_8879, 1);
            replacementItem.method_57379(class_9334.field_49631, class_2561.method_43470("Bookmark " + name));
            replacementItem.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, "★");
        }
    }

    public static String findItemName(ChestLoadedEvent e){
        String nameFromContainer = findItemNameFromContainer();
        if(!OrderInfoContainer.isValidName(nameFromContainer) || nameFromContainer.length() >= 30 ) {
            return findNameFromItemStacks(e.getItemStacks(), nameFromContainer);
        }
        return nameFromContainer;
    }

    private static String findNameFromItemStacks(List<class_1799> itemStacks, String nameFromContainer){
        for(class_1799 stack : itemStacks){
            if(stack == null) continue;
            if (!stack.method_7960() && stack.method_7964().getString().startsWith(nameFromContainer)) {
                return stack.method_65130().getString();
            }
        }
        return "???";
    }

    private static String findItemNameFromContainer(){
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        String containerName = screenInfo.getContainerName();
        if(screenInfo.inMenu(ScreenInfo.BazaarMenuType.INSTA_BUY)) {
            return containerName.substring(0, containerName.indexOf("➜")-1);
        } else {
            return containerName.substring(containerName.indexOf("➜") + 2);
        }
    }


    private static class_1799 findItemStack(String name){
        class_1703 handler = GUIUtils.getHandledScreen();

        if(handler == null) return null;
        for(class_1735 slot : handler.field_7761){
            class_1799 itemStack = slot.method_7677();
            if(itemStack == null) continue;

            if (!itemStack.method_7960() && itemStack.method_7964().getString().startsWith(name)) {
                return itemStack;
            }
        }
        for(class_1735 slot : handler.field_7761){
            class_1799 itemStack = slot.method_7677();

            if (!itemStack.method_7960() && itemStack.method_7964().getString().contains(name)) {
                return itemStack;
            }
        }
        return class_1802.field_8477.method_7854();
    }

    public static boolean isItemBookmarked(String itemName){
        return findMatchingBookmark(itemName).isPresent();
    }

    public static Optional<Bookmark> findMatchingBookmark(String itemName){
        return BUConfig.get().bookmarks.stream().filter(bookmark -> bookmark.getName().equalsIgnoreCase(itemName)).findAny();
    }

    @RegisterWidget
    public static List<ItemSlotButtonWidget> getWidgets(){
        List<ItemSlotButtonWidget> widgets = new ArrayList<>();
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        boolean isTargetScreen = screenInfo.inMenu(ScreenInfo.BazaarMenuType.BAZAAR_MAIN_PAGE);

        if(!(class_310.method_1551().field_1755 instanceof AccessorHandledScreen screen) || !isTargetScreen)
            return Collections.emptyList();



        ItemSlotButtonWidget.ScreenWidgetDimensions dimensions = ItemSlotButtonWidget.getSafeScreenDimensions(screen, screenInfo.getContainerName());

            int buttonSize = 18;
            int spacing = 4;
            int buttonX = dimensions.x() + dimensions.backgroundWidth() + spacing;
            int currentButtonY = dimensions.y() + spacing;

            List<Bookmark> bookmarks = BUConfig.get().bookmarks;

            for (int i = 0; i < bookmarks.size(); i++) {
                class_1799 configuredItem = bookmarks.get(i).getBookmarkedItemStack();

                final int buttonIndex = i;
                final class_1799 itemForButton = (configuredItem == null) ? class_1802.field_8077.method_7854() : configuredItem;
                final Bookmark bookmark = bookmarks.get(buttonIndex);
                class_5250 text = class_2561.method_43470(bookmark.getName()).formatted(class_124.field_1067);

                OrderInfoContainer orderInfo = bookmark.getOrderInfo();
                orderInfo.updateMarketPrice();

                class_2583 style = class_2583.field_24360.method_10977(class_124.field_1080).method_10982(false);
                text.method_10852(class_2561.method_43470("\nBuy: " + Util.getPrettyString(orderInfo.getMarketPrice(PriceInfoContainer.PriceType.INSTASELL)) + " coins").method_10862(style));
                text.method_10852(class_2561.method_43470("\nSell: " + Util.getPrettyString(orderInfo.getMarketPrice(PriceInfoContainer.PriceType.INSTABUY)) + " coins").method_10862(style));

                ItemSlotButtonWidget button = new ItemSlotButtonWidget(
                        buttonX,
                        currentButtonY,
                        buttonSize, buttonSize,
                        SLOT_BUTTON_TEXTURES,
                        (btn) -> {
                            if (class_437.method_25442()) {
                                PlayerActionUtil.notifyAll("Removed " + bookmark.getName() + " bookmark from shift-click. Open Bazaar again to display changes.");
                                bookmark.onWidgetShiftClick();
                            } else {
                                bookmark.onWidgetLeftClick();
                            }

                        },
                        itemForButton,
                        text
                );

                widgets.add(button);
                currentButtonY += buttonSize + spacing;
            }

        return widgets;
    }

}
