package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.utils.GUIUtils;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import de.siphalor.amecs.api.AmecsKeyBinding;
import de.siphalor.amecs.api.KeyModifiers;
import lombok.Getter;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

//TODO make using amecs optional
public class StashHelper extends AmecsKeyBinding {
    @Getter
    private transient int ticksBetweenPresses;

    public StashHelper() {
        super("Pick Up Stash", class_3675.class_307.field_1668, GLFW.GLFW_KEY_V, "Bazaar utils", new KeyModifiers(true, false, false, false));
        ticksBetweenPresses = 0;
    }

    @Override
    public void onPressed(){
        if(ticksBetweenPresses>10) {
            ticksBetweenPresses = 0;
            GUIUtils.closeHandledScreen();
            PlayerActionUtil.runCommand("pickupstash");
        }
    }

    public void registerTickCounter() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            ticksBetweenPresses++;
        });
    }

    public String getUsage(){
        return getModifierString(getDefaultModifiers().getValue()) +"+" + method_1429().method_27445().getString();
    }

    private static String getModifierString(boolean[] modifiers) {
        String modifierString = "";
        if(modifiers[0])
            modifierString += "ALT";
        if(modifiers[1])
            modifierString += "CTRL";
        if(modifiers[2])
            modifierString += "SHIFT";
        return modifierString;
    }


}
