// MixinHandledScreen.java
package com.github.mkram17.bazaarutils.mixin;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.SlotClickEvent;
import com.github.mkram17.bazaarutils.features.OrderStatusHighlight;
import com.github.mkram17.bazaarutils.features.StashHelper;
import com.github.mkram17.bazaarutils.features.restrictsell.RestrictSell;
import com.github.mkram17.bazaarutils.misc.BUCompatibilityHelper;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

//used for SlotClickEvent, register keybinds in chests, block slot clicks
@Mixin(value = class_465.class, priority = 999)
public abstract class MixinHandledScreen<T extends class_1703> extends class_437 {


	protected MixinHandledScreen(class_2561 title) {
		super(title);
	}

	@Inject(method = "onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V", at = @At("HEAD"), cancellable = true)
	private void onHandleMouseClick(class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
		if (slot == null) return;

		//for insta sell rules
		RestrictSell sell = BUConfig.get().restrictSell;
		if (sell.isSlotLocked(slotId)) {
			if (sell.getSafetyClicks() < 3) {
				sell.addSafetyClick();
				PlayerActionUtil.notifyAll(sell.getMessage());
				ci.cancel();
			} else {
				sell.resetSafetyClicks();
			}
		}

		class_465<?> screen = (class_465<?>) (Object) this;
		SlotClickEvent event = new SlotClickEvent(screen, slot, slotId, button, actionType);
		BazaarUtils.EVENT_BUS.post(event);
		// Use the accessor to safely get the client instance
		class_310 client = ((AccessorScreen) screen).getClient();
		if (event.isCancelled()) {
			ci.cancel();
			return;
		}

		if (event.usePickblockInstead) {
			assert client != null && client.field_1724 != null;
			client.field_1761.method_2906(
					screen.method_17577().field_7763,
					slotId,
					2,
					class_1713.field_7790,
					client.field_1724
			);
			ci.cancel();
		}
	}

	@IfModLoaded(BUCompatibilityHelper.AMECS_MODID)
	@Inject(method = "keyPressed", at = @At("HEAD"), cancellable = true)
	public void onkeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
		StashHelper keyBinding = (StashHelper) BazaarUtils.keybinds.getFirst();
		if (!keyBinding.method_1434() && keyBinding.method_1429().method_1444() == keyCode && keyBinding.getDefaultModifiers().getAlt()) {
//			Util.notifyAll("Stash helper pressed", Util.notificationTypes.FEATURE);
			if (keyBinding.getTicksBetweenPresses() > 10)
				keyBinding.method_23481(true);
			cir.setReturnValue(true);
		}
	}

	@Inject(method = "init", at = @At("TAIL"))
	private void bazaarutils$addConfiguredButtons(CallbackInfo ci) {
		int buttonsAdded = 0;
		for (class_339 button : BUConfig.getWidgets()) {
			this.method_37063(button);
			buttonsAdded++;
		}
	}

	@Inject(method = "drawSlot", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawItem(Lnet/minecraft/item/ItemStack;III)V"))
	private void bazaarutils$drawOnItem(class_332 context, class_1735 slot, CallbackInfo ci) {
		ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
		if (slot == null || !BUConfig.get().orderStatusHighlight.isEnabled() || !screenInfo.inMenu(ScreenInfo.BazaarMenuType.ORDER_SCREEN) || !slot.method_7681())
			return;
		if (class_310.method_1551().field_1724 != null && slot.field_7871 == class_310.method_1551().field_1724.method_31548())
			return;

		BazaarOrder order = OrderStatusHighlight.getHighlightedOrder(slot.method_34266());
		if(order == null || order.getFillStatus() == OrderInfoContainer.Statuses.FILLED)
			return;

		draw(context, slot.field_7873, slot.field_7872, order.getOutbidStatus());

	}

	@Unique
	protected void draw(class_332 context, int x, int y, OrderInfoContainer.Statuses orderStatus) {
		final float r, g, b;
		if (orderStatus == OrderInfoContainer.Statuses.COMPETITIVE) {
			r = 0.0f; g = 1.0f; b = 0.0f; // Green
		} else if (orderStatus == OrderInfoContainer.Statuses.OUTBID) {
			r = 1.0f; g = 0.0f; b = 0.0f; // Red
		} else { // MATCHED
			r = 1.0f; g = 1.0f; b = 0.0f; // Yellow
		}

		final int color = class_9848.method_61318(OrderStatusHighlight.BACKGROUND_TRANSPARENCY, r, g, b);
		final var sprite = class_310.method_1551()
				.method_52699()
				.method_18667(OrderStatusHighlight.IDENTIFIER);

		//? if > 1.21.5 {
		/*context.drawSpriteStretched(RenderPipelines.GUI_TEXTURED,
				sprite, x, y, 16, 16, color
		);
		*///?} else {
		context.method_52710(class_1921::method_62277,
				sprite, x, y, 16, 16, color
		);
		//?}
	}

}
