package com.github.mkram17.bazaarutils.utils;

import com.github.mkram17.bazaarutils.events.ChestLoadedEvent;
import com.github.mkram17.bazaarutils.events.SignOpenEvent;
import com.github.mkram17.bazaarutils.features.Bookmark;
import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import com.github.mkram17.bazaarutils.mixin.AccessorSignEditScreen;
import lombok.Getter;
import lombok.Setter;
import meteordevelopment.orbit.EventHandler;
import meteordevelopment.orbit.EventPriority;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2815;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_498;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_7743;
import java.util.function.Predicate;

import static com.github.mkram17.bazaarutils.BazaarUtils.EVENT_BUS;

//TODO make inBazaar() work all the time
public class GUIUtils {
    @Getter @Setter
    private static guiTypes guiType;
    @Getter @Setter
    private static class_1263 lowerChestInventory;
    @Getter @Setter
    private static Bookmark currentBookmark;

    @RunOnInit
    public static void subscribe() {
        EVENT_BUS.subscribe(GUIUtils.class);
    }

    public enum guiTypes {CHEST, SIGN}


    @RunOnInit
    public static void registerScreenEvent(){
        ScreenEvents.AFTER_INIT.register((client, screen, width, height) -> {
            lowerChestInventory = null;
            ScreenInfo currentInfo = ScreenInfo.getCurrentScreenInfo();
            if(screen != null && currentInfo == null)
                currentInfo = new ScreenInfo(screen);
        });
    }

    public static class_1703 getHandledScreen() {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) return null;
        return client.field_1724.field_7512;
    }

    @EventHandler(priority = EventPriority.HIGH)
    private static void loadSign(SignOpenEvent e){
        guiType = guiType.SIGN;
    }

    @EventHandler(priority = EventPriority.HIGH)
    private static void setUpBookmark(ChestLoadedEvent e){
        currentBookmark = null;
        if(!ScreenInfo.getCurrentScreenInfo().inMenu(ScreenInfo.BazaarMenuType.INDIVIDUAL_ITEM))
            return;
        String name = Bookmark.findItemName(e);
        if (Bookmark.isItemBookmarked(name)) {
            currentBookmark = Bookmark.findMatchingBookmark(name).get();
            EVENT_BUS.subscribe(currentBookmark);
        } else
            currentBookmark = new Bookmark(name);
    }
    @EventHandler(priority = EventPriority.HIGHEST)
    private static void onLoad(ChestLoadedEvent e){
        guiType = guiType.CHEST;
        lowerChestInventory = e.getLowerChestInventory();
    }

    public static void closeHandledScreen() {
        try {
            PlayerActionUtil.notifyAll("Closing gui", Util.notificationTypes.GUI);
            class_310 client = class_310.method_1551();
            if (client == null) {
                Util.notifyError("Client is null", new Throwable());
                return;
            }
            if(!(client.field_1755 instanceof class_465<?>))
                return;

            client.execute(GUIUtils::customCloseHandledScreen);
        } catch (Exception e) {
            Util.notifyError("Error closing gui", e);
        }
    }

    private static void customCloseHandledScreen() {
        try {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (player == null) {
                Util.notifyError("Player is null, cannot close screen", new Throwable());
                return;
            }
            player.field_3944.method_52787(new class_2815(player.field_7512.field_7763));
            client.method_1507(null);
            player.field_7512 = player.field_7498;

        } catch (Exception e) {
            Util.notifyError("Error encountered while closing screen with custom method", e);
            throw new RuntimeException(e);
        }
    }

    public static void closeSign(){
        try {
            PlayerActionUtil.notifyAll("Closing sign", Util.notificationTypes.GUI);
            class_310 mcclient = class_310.method_1551();
            if (mcclient != null && mcclient.field_1755 instanceof class_7743 signEditScreen) {
                mcclient.execute(signEditScreen::method_25419);
            } else {
                Util.notifyError("Error closing sign: client was null or not in a sign", new Throwable());
            }
        } catch (Exception e) {
            e.printStackTrace();
            Util.notifyError("Unknown error while closing sign", e);
        }
    }

    public static void setSignText(String text, boolean closeAfter) {
        setSignTextInternal(text, closeAfter, 5);
    }

    private static void setSignTextInternal(String text, boolean closeAfter, int attemptsLeft) {
        if (attemptsLeft <= 0) {
            Util.notifyError("Failed to set sign text: Screen not available.", new Throwable());
            return;
        }

        class_310 client = class_310.method_1551();
        if (client == null) {
            Util.notifyError("Failed to set sign text: MinecraftClient is null.", new Throwable());
            return;
        }

        client.execute(() -> {
            if (client.field_1755 instanceof class_498 screen) {
                try {
                    AccessorSignEditScreen signScreen = (AccessorSignEditScreen) screen;
                    String[] lines = text.split("\n", 4);
                    int originalRow = signScreen.getCurrentRow();

                    for (int i = 0; i < 4; i++) {
                        String line = i < lines.length ? lines[i] : "";
                        signScreen.setCurrentRow(i);
                        signScreen.callSetCurrentRowMessage(line);
                    }
                    signScreen.setCurrentRow(originalRow);

                    if (closeAfter) {
                        closeSign();
                    }
                } catch (Exception e) {
                    Util.notifyError("Error executing sign text update", e);
                    e.printStackTrace();
                }
            } else {
                // Screen not open yet, schedule a retry
                Util.tickExecuteLater(4, () -> setSignTextInternal(text, closeAfter, attemptsLeft - 1));
            }
        });
    }

    public static void clickSlot(int slotIndex, int button) {
        class_310 client = class_310.method_1551();
        class_636 interactionManager = client.field_1761;
        class_746 player = client.field_1724;

        if (interactionManager == null || player == null) return;

        class_1703 screenHandler = player.field_7512;
        int syncId = screenHandler.field_7763;
        Util.tickExecuteLater(1, () -> {
            interactionManager.method_2906(
                    syncId,
                    slotIndex,
                    button,
                    class_1713.field_7790,
                    player
            );
        });
    }
    public static class_1799 getChestItem(int chestSlot) {
        if (guiType != guiTypes.CHEST) return class_1799.field_8037;
        if (lowerChestInventory == null) return class_1799.field_8037;
        if (chestSlot < 0 || chestSlot >= lowerChestInventory.method_5439()) return class_1799.field_8037;
        class_1799 stack = lowerChestInventory.method_5438(chestSlot);
        return stack == null ? class_1799.field_8037 : stack;
    }
}
