/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils;

import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.data.BazaarData;
import com.github.mkram17.bazaarutils.events.ChestLoadedEvent;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.events.handlers.BazaarChatEventHandler;
import com.github.mkram17.bazaarutils.events.handlers.ChatHandler;
import com.github.mkram17.bazaarutils.features.Bookmark;
import com.github.mkram17.bazaarutils.features.OrderLimit;
import com.github.mkram17.bazaarutils.features.StashHelper;
import com.github.mkram17.bazaarutils.misc.BUCompatibilityHelper;
import com.github.mkram17.bazaarutils.misc.JoinMessages;
import com.github.mkram17.bazaarutils.misc.MajorUpdateActions;
import com.github.mkram17.bazaarutils.utils.BUCommands;
import com.github.mkram17.bazaarutils.utils.GUIUtils;
import com.github.mkram17.bazaarutils.utils.OrderUpdater;
import com.github.mkram17.bazaarutils.utils.ResourceManager;
import com.github.mkram17.bazaarutils.utils.TimeUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import de.siphalor.amecs.api.AmecsKeyBinding;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import meteordevelopment.orbit.EventBus;
import meteordevelopment.orbit.IEventBus;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public class BazaarUtils
implements ClientModInitializer {
    public static IEventBus EVENT_BUS = new EventBus();
    public static StashHelper stashHelper;
    public static ArrayList<class_304> keybinds;
    public static final String MODID = "bazaarutils";
    public static final String MOD_NAME = "Bazaar Utils";
    public static boolean updatedMajorVersion;
    private static String updateNotes;
    public static ScheduledExecutorService BUExecutorService;
    public static class_9331<String> CUSTOM_SIZE_COMPONENT;
    public static class_9331<Boolean> CUSTOM_SHOWPRICECHART_COMPONENT;

    public void onInitializeClient() {
        BazaarUtils.registerDataComponents();
        BUConfig.HANDLER.load();
        BUCompatibilityHelper.initializePatches();
        this.getModProperties();
        this.registerEventBus();
        this.subscribeEvents();
        BazaarUtils.registerCommands();
        this.registerKeybinds();
        this.setDefaultValues();
        BazaarData.init();
        ChestLoadedEvent.registerScreenEvent();
        BazaarChatEventHandler.subscribe();
        ChatHandler.registerBazaarChat();
        OrderLimit.registerBazaarOpen();
        JoinMessages.registerWelcomeMessageSender();
        MajorUpdateActions.runIfUpdated();
        GUIUtils.subscribe();
        GUIUtils.registerScreenEvent();
        OrderUpdater.subscribe();
        ResourceManager.onClientStart();
        TimeUtil.startTimer();
        Util.subscribeTicks();
        JoinMessages.initializeFields();
    }

    private static void registerDataComponents() {
        CUSTOM_SIZE_COMPONENT = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)MODID, (String)"custom_size"), (Object)class_9331.method_57873().method_57881((Codec)Codec.STRING).method_57880());
        CUSTOM_SHOWPRICECHART_COMPONENT = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)MODID, (String)"has_price_chart"), (Object)class_9331.method_57873().method_57881((Codec)Codec.BOOL).method_57880());
    }

    private void registerEventBus() {
        EVENT_BUS.registerLambdaFactory("com.github.mkram17.bazaarutils", (lookupInMethod, klass) -> (MethodHandles.Lookup)lookupInMethod.invoke(null, klass, MethodHandles.lookup()));
    }

    public static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> BUCommands.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    private void subscribeEvents() {
        for (BUListener listener : BUListener.getEventListeners()) {
            listener.subscribe();
        }
    }

    private void registerKeybinds() {
        if (!BUCompatibilityHelper.isAmecsReborn()) {
            return;
        }
        stashHelper = new StashHelper();
        stashHelper.registerTickCounter();
        keybinds.add((class_304)stashHelper);
        for (class_304 keybind : keybinds) {
            if (!(keybind instanceof AmecsKeyBinding)) continue;
            KeyBindingHelper.registerKeyBinding((class_304)keybind);
        }
    }

    private void setDefaultValues() {
        if (BUConfig.get().bookmarks.isEmpty()) {
            BUConfig.get().bookmarks.add(new Bookmark("Diamond"));
        }
    }

    private void getModProperties() {
        FabricLoader.getInstance().getModContainer(MODID).ifPresent(modContainer -> {
            ModMetadata metadata = modContainer.getMetadata();
            CustomValue updateNotesValue = metadata.getCustomValue("latestMajorUpdateNotes");
            if (updateNotesValue != null) {
                updateNotes = updateNotesValue.getAsString();
            }
            String oldVersion = BUConfig.get().MOD_VERSION;
            String currentVersion = metadata.getVersion().getFriendlyString();
            String oldVersionMajor = oldVersion.substring(oldVersion.indexOf(".") + 1);
            String currentVersionMajor = currentVersion.substring(currentVersion.indexOf(".") + 1);
            BUConfig.get().MOD_VERSION = currentVersion;
            Util.scheduleConfigSave();
            if (!oldVersionMajor.equals(currentVersionMajor)) {
                updatedMajorVersion = true;
            }
        });
    }

    @Generated
    public static String getUpdateNotes() {
        return updateNotes;
    }

    static {
        keybinds = new ArrayList();
        updatedMajorVersion = false;
        BUExecutorService = Executors.newSingleThreadScheduledExecutor();
    }
}

