/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.config;

import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.handlers.ChatHandler;
import com.github.mkram17.bazaarutils.features.CustomOrder;
import com.github.mkram17.bazaarutils.features.restrictsell.RestrictSell;
import com.github.mkram17.bazaarutils.misc.BUCompatibilityHelper;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;

public class BUConfigGui {
    public static class_437 create(class_437 parent, BUConfig config) {
        return YetAnotherConfigLib.create(BUConfig.HANDLER, (defaults, cfg, builder) -> {
            builder.title((class_2561)class_2561.method_43470((String)"Bazaar Utils"));
            BUConfigGui.buildGeneralCategory(builder, config);
            BUConfigGui.buildCustomOrdersCategory(builder);
            if (config.developerMode) {
                BUConfigGui.buildDeveloperCategory(builder, config.developer);
            }
            return builder;
        }).generateScreen(parent);
    }

    private static void buildGeneralCategory(YetAnotherConfigLib.Builder builder, BUConfig config) {
        ConfigCategory.Builder generalBuilder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"General"));
        generalBuilder.option(config.flipHelper.createOption());
        generalBuilder.options(config.outbidOrderHandler.createOptions());
        generalBuilder.option(ChatHandler.createOrderFilledSoundOption());
        generalBuilder.option(config.stashMessages.createOption());
        generalBuilder.option(config.priceCharts.createOption());
        generalBuilder.option(config.orderStatusHighlight.createOption());
        generalBuilder.option(BUConfigGui.createDisableErrorNotifsOption(config));
        if (!BUCompatibilityHelper.isAmecsReborn()) {
            generalBuilder.option((Option)BUConfigGui.createAmecsDownloadButton());
        }
        generalBuilder.group(BUConfigGui.buildRestrictSellGroup(config.restrictSell));
        generalBuilder.group(config.orderLimit.buildOrderLimitGroup());
        builder.category(generalBuilder.build());
    }

    private static OptionGroup buildRestrictSellGroup(RestrictSell restrictSell) {
        OptionGroup.Builder restrictSellGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43470((String)"Sell rules")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Blocks insta selling based on rules. You can add a new rule with /bu rule add {based on volume or price} {amount over which will be restricted} or you can remove it with /bu rule remove {rule number}")}));
        if (restrictSell.getControls().isEmpty()) {
            restrictSell.addRule(RestrictSell.restrictBy.PRICE, 1000000.0);
        }
        restrictSell.buildOptions(restrictSellGroupBuilder);
        return restrictSellGroupBuilder.build();
    }

    private static void buildCustomOrdersCategory(YetAnotherConfigLib.Builder builder) {
        OptionGroup.Builder customOrdersGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43470((String)"Custom Buy Amounts")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Add buttons for custom buy order/insta buy amounts. To add more do /bu customorder add {order amount} {slot number} (top left slot is slot #1, to the right is #2, etc etc.")}));
        CustomOrder.buildOptions(customOrdersGroupBuilder);
        builder.category(CustomOrder.createOrdersCategory().group(customOrdersGroupBuilder.build()).build());
    }

    private static void buildDeveloperCategory(YetAnotherConfigLib.Builder builder, BUConfig.Developer developer) {
        ConfigCategory.Builder developerBuilder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Developer"));
        developerBuilder.option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"All Messages")).binding((Object)developer.allMessages, () -> developer.allMessages, newVal -> {
            developer.allMessages = newVal;
        }).controller(BUConfigGui::createBooleanController).build());
        developerBuilder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43470((String)"Message Options")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"DEVELOPER ONLY")})).options(developer.createOptions()).build());
        builder.category(developerBuilder.build());
    }

    private static Option<Boolean> createDisableErrorNotifsOption(BUConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Disable Error Notifications")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Not recommended to enable this unless you are experiencing error spam. This will disable all error notifications, but not the errors themselves.")})).binding((Object)config.disableErrorNotifications, () -> config.disableErrorNotifications, newVal -> {
            config.disableErrorNotifications = newVal;
        }).controller(BUConfigGui::createBooleanController).build();
    }

    private static ButtonOption createAmecsDownloadButton() {
        return ButtonOption.createBuilder().name(class_2561.method_30163((String)"Download Amecs Reborn")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Amecs Reborn is needed for the Stash Helper feature. Download here.")})).text(class_2561.method_30163((String)"(for Stash Helper)")).action((yaclScreen, buttonOption) -> class_310.method_1551().method_1507((class_437)new class_407(confirmed -> {
            if (confirmed) {
                try {
                    class_156.method_668().method_673(new URI("https://modrinth.com/mod/amecs-reborn"));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            class_310.method_1551().method_1507(null);
        }, "https://modrinth.com/mod/amecs-reborn", true))).build();
    }

    public static BooleanControllerBuilder createBooleanController(Option<Boolean> opt) {
        return BooleanControllerBuilder.create(opt).onOffFormatter().coloured(true);
    }
}

