/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.events;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import meteordevelopment.orbit.ICancellable;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_476;
import net.minecraft.class_9334;

public class ChestLoadedEvent
implements ICancellable {
    private class_1263 lowerChestInventory;
    private List<class_1799> itemStacks = new ArrayList<class_1799>();
    private String containerName;
    public static final ChestLoadedEvent INSTANCE = new ChestLoadedEvent();

    @RunOnInit
    public static void registerScreenEvent() {
        ScreenEvents.AFTER_INIT.register((client, screen, width, height) -> {
            if (screen instanceof class_476) {
                final class_476 genericContainerScreen = (class_476)screen;
                class GuiLoadedChecker
                implements Runnable {
                    private int attempts = 0;
                    private final int MAX_ATTEMPTS = 50;
                    private final long DELAY_MS = 40L;

                    GuiLoadedChecker() {
                    }

                    @Override
                    public void run() {
                        if (client.field_1755 != genericContainerScreen) {
                            return;
                        }
                        class_1703 handler = genericContainerScreen.method_17577();
                        if (handler instanceof class_1707) {
                            class_1707 containerHandler = (class_1707)handler;
                            class_1263 inv = containerHandler.method_7629();
                            if (inv.method_5439() > 0 && !inv.method_5438(inv.method_5439() - 1).method_7960() && !ChestLoadedEvent.isItemLoading(inv)) {
                                ChestLoadedEvent event = new ChestLoadedEvent();
                                event.lowerChestInventory = inv;
                                event.containerName = ScreenInfo.getCurrentScreenInfo().getContainerName();
                                event.itemStacks = ChestLoadedEvent.getChestItemSlots(inv);
                                BazaarUtils.EVENT_BUS.post((ICancellable)event);
                            } else {
                                ++this.attempts;
                                if (this.attempts < 50) {
                                    CompletableFuture.runAsync(() -> {
                                        try {
                                            Thread.sleep(40L);
                                            client.execute((Runnable)this);
                                        }
                                        catch (InterruptedException e) {
                                            Thread.currentThread().interrupt();
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
                client.execute((Runnable)new GuiLoadedChecker());
            }
        });
    }

    private static List<class_1799> getChestItemSlots(class_1263 inventory) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    private static boolean isItemLoading(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            String displayName;
            class_2561 customName;
            class_1799 item = inventory.method_5438(i);
            if (item.method_7960() || (customName = (class_2561)item.method_58694(class_9334.field_49631)) == null || !(displayName = Util.removeFormatting(customName.getString())).contains("Loading")) continue;
            PlayerActionUtil.notifyAll("Loading item...", Util.notificationTypes.GUI);
            return true;
        }
        return false;
    }

    public void setCancelled(boolean b) {
    }

    public boolean isCancelled() {
        return false;
    }

    @Generated
    public class_1263 getLowerChestInventory() {
        return this.lowerChestInventory;
    }

    @Generated
    public List<class_1799> getItemStacks() {
        return this.itemStacks;
    }

    @Generated
    public String getContainerName() {
        return this.containerName;
    }
}

