/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.events.handlers;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.BazaarChatEvent;
import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.SoundUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import java.util.Optional;
import meteordevelopment.orbit.EventHandler;

public class BazaarChatEventHandler {
    public static final int ORDER_FILLED_NOTIFICATIONS = 2;

    @EventHandler
    private static void onAnyOrder(BazaarChatEvent<? extends OrderInfoContainer> event) {
        PlayerActionUtil.notifyAll("Bazaar Order: " + event.type().name(), Util.notificationTypes.ORDERDATA);
    }

    @EventHandler
    private static void onOrderCreated(BazaarChatEvent<? extends OrderInfoContainer> event) {
        OrderInfoContainer orderInfoContainer;
        if (event.type() != BazaarChatEvent.BazaarEventTypes.ORDER_CREATED || !((orderInfoContainer = event.order()) instanceof BazaarOrder)) {
            return;
        }
        BazaarOrder bazaarOrder = (BazaarOrder)orderInfoContainer;
        BUConfig.get().orderLimit.addOrderToLimit((double)bazaarOrder.getVolume().intValue() * bazaarOrder.getPricePerItem());
        Util.addWatchedOrder(bazaarOrder);
    }

    @EventHandler
    private static void onInstaSell(BazaarChatEvent<? extends OrderInfoContainer> event) {
        if (event.type() != BazaarChatEvent.BazaarEventTypes.INSTA_SELL) {
            return;
        }
        OrderInfoContainer order = event.order();
        double totalPriceBeforeTax = (double)order.getVolume().intValue() * order.getPricePerItem();
        double totalPriceWithTax = totalPriceBeforeTax * ((100.0 + BUConfig.get().bzTax) / 100.0);
        BUConfig.get().orderLimit.addOrderToLimit(totalPriceBeforeTax);
        PlayerActionUtil.notifyAll("Insta sell for " + String.valueOf(order), Util.notificationTypes.FEATURE);
    }

    @EventHandler
    private static void onInstaBuy(BazaarChatEvent<? extends OrderInfoContainer> event) {
        if (event.type() != BazaarChatEvent.BazaarEventTypes.INSTA_BUY) {
            return;
        }
        OrderInfoContainer order = event.order();
        double totalPrice = (double)order.getVolume().intValue() * order.getPricePerItem();
        BUConfig.get().orderLimit.addOrderToLimit(totalPrice);
        PlayerActionUtil.notifyAll("Insta sell for " + String.valueOf(order), Util.notificationTypes.FEATURE);
    }

    @EventHandler
    private static void onOrderFilled(BazaarChatEvent<? extends OrderInfoContainer> event) {
        OrderInfoContainer order;
        Optional<BazaarOrder> orderMatch;
        if (event.type() != BazaarChatEvent.BazaarEventTypes.ORDER_FILLED) {
            return;
        }
        if (BUConfig.get().isOrderFilledSound()) {
            SoundUtil.notifyMultipleTimes(2);
        }
        if ((orderMatch = (order = event.order()).findOrderInList(BUConfig.get().userOrders)).isPresent()) {
            orderMatch.get().setFilled();
            PlayerActionUtil.notifyAll(order.getName() + "[" + orderMatch.get().getIndex() + "] was filled", Util.notificationTypes.ORDERDATA);
        } else {
            Util.notifyError("Could not find item to fill with info vol: " + order.getVolume() + " name: " + order.getName(), new Exception("Order Filled Event error"));
        }
    }

    @RunOnInit
    public static void subscribe() {
        BazaarUtils.EVENT_BUS.subscribe(BazaarChatEventHandler.class);
    }
}

