/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.ChestLoadedEvent;
import com.github.mkram17.bazaarutils.events.ReplaceItemEvent;
import com.github.mkram17.bazaarutils.events.SlotClickEvent;
import com.github.mkram17.bazaarutils.misc.BUCompatibilityHelper;
import com.github.mkram17.bazaarutils.misc.CustomItemButton;
import com.github.mkram17.bazaarutils.misc.autoregistration.RegisterWidget;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.misc.widgets.ItemSlotButtonWidget;
import com.github.mkram17.bazaarutils.mixin.AccessorHandledScreen;
import com.github.mkram17.bazaarutils.utils.GUIUtils;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.SoundUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_8666;
import net.minecraft.class_9334;

public class Bookmark
extends CustomItemButton {
    public final String name;
    public class_1799 bookmarkedItemStack;
    private final OrderInfoContainer orderInfo;
    private static final int SIGN_SLOT_NUMBER = 45;
    private static final class_2960 BASE = class_2960.method_43902((String)"bazaarutils", (String)"widget/bookmark_widget_base");
    private static final class_2960 HOVER = class_2960.method_43902((String)"bazaarutils", (String)"widget/bookmark_widget_hover");
    public static final class_8666 SLOT_BUTTON_TEXTURES = new class_8666(BASE, HOVER);

    @Override
    @EventHandler
    protected void onGuiLoad(ChestLoadedEvent event) {
        BazaarUtils.EVENT_BUS.unsubscribe((Object)this);
    }

    public Bookmark(String name) {
        this.name = name;
        this.slotNumber = 0;
        this.changeVisuals(Bookmark.isItemBookmarked(this.name));
        this.replacementItem.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, (Object)"\u2605");
        this.bookmarkedItemStack = Bookmark.findItemStack(name);
        this.orderInfo = new OrderInfoContainer(name, null, null, PriceInfoContainer.PriceType.INSTABUY, null);
        BazaarUtils.EVENT_BUS.subscribe((Object)this);
    }

    @EventHandler
    protected void replaceItemEvent(ReplaceItemEvent event) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        try {
            if (!super.shouldReplaceItem(event) || this.bookmarkedItemStack == null && !BUConfig.get().bookmarks.contains(this)) {
                return;
            }
            if (this.replacementItem == null) {
                this.changeVisuals(Bookmark.isItemBookmarked(this.name));
            }
            event.setReplacement(this.replacementItem);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    private void onBookmarkClick(SlotClickEvent event) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        if (!super.shouldUseSlot(event)) {
            return;
        }
        SoundUtil.playSound((class_6880<class_3414>)BUTTON_SOUND, 0.2f);
        this.reverseBookmarkStatus();
        this.bookmarkedItemStack = Bookmark.findItemStack(this.name);
        Util.scheduleConfigSave();
    }

    public void onWidgetLeftClick() {
        SoundUtil.playSound((class_6880<class_3414>)BUTTON_SOUND, 0.2f);
        boolean userHasSkyblockerBazaarOverlay = BUCompatibilityHelper.isSkyblockerBazaarOverlayEnabled();
        if (userHasSkyblockerBazaarOverlay) {
            BUCompatibilityHelper.setSkyblockerBazaarOverlayValue(false);
        }
        GUIUtils.clickSlot(45, 0);
        GUIUtils.setSignText(this.name, true);
        if (userHasSkyblockerBazaarOverlay) {
            Util.tickExecuteLater(10, () -> BUCompatibilityHelper.setSkyblockerBazaarOverlayValue(true));
        }
    }

    public void onWidgetShiftClick() {
        BUConfig.get().bookmarks.remove(this);
        Util.scheduleConfigSave();
    }

    private void reverseBookmarkStatus() {
        if (Bookmark.isItemBookmarked(this.name)) {
            this.changeVisuals(false);
            BUConfig.get().bookmarks.remove(this);
        } else {
            this.changeVisuals(true);
            BUConfig.get().bookmarks.add(this);
        }
        Util.scheduleConfigSave();
    }

    private void changeVisuals(boolean bookmarked) {
        if (bookmarked) {
            this.replacementItem = new class_1799((class_1935)class_1802.field_8656, 1);
            this.replacementItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Remove " + this.name + " Bookmark")));
            this.replacementItem.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, (Object)"\u20e0 ");
        } else {
            this.replacementItem = new class_1799((class_1935)class_1802.field_8879, 1);
            this.replacementItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Bookmark " + this.name)));
            this.replacementItem.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, (Object)"\u2605");
        }
    }

    public static String findItemName(ChestLoadedEvent e) {
        String nameFromContainer = Bookmark.findItemNameFromContainer();
        if (!OrderInfoContainer.isValidName(nameFromContainer) || nameFromContainer.length() >= 30) {
            return Bookmark.findNameFromItemStacks(e.getItemStacks(), nameFromContainer);
        }
        return nameFromContainer;
    }

    private static String findNameFromItemStacks(List<class_1799> itemStacks, String nameFromContainer) {
        for (class_1799 stack : itemStacks) {
            if (stack == null || stack.method_7960() || !stack.method_7964().getString().startsWith(nameFromContainer)) continue;
            return stack.method_65130().getString();
        }
        return "???";
    }

    private static String findItemNameFromContainer() {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        String containerName = screenInfo.getContainerName();
        if (screenInfo.inMenu(ScreenInfo.BazaarMenuType.INSTA_BUY)) {
            return containerName.substring(0, containerName.indexOf("\u279c") - 1);
        }
        return containerName.substring(containerName.indexOf("\u279c") + 2);
    }

    private static class_1799 findItemStack(String name) {
        class_1799 itemStack;
        class_1703 handler = GUIUtils.getHandledScreen();
        if (handler == null) {
            return null;
        }
        for (class_1735 slot : handler.field_7761) {
            itemStack = slot.method_7677();
            if (itemStack == null || itemStack.method_7960() || !itemStack.method_7964().getString().startsWith(name)) continue;
            return itemStack;
        }
        for (class_1735 slot : handler.field_7761) {
            itemStack = slot.method_7677();
            if (itemStack.method_7960() || !itemStack.method_7964().getString().contains(name)) continue;
            return itemStack;
        }
        return class_1802.field_8477.method_7854();
    }

    public static boolean isItemBookmarked(String itemName) {
        return Bookmark.findMatchingBookmark(itemName).isPresent();
    }

    public static Optional<Bookmark> findMatchingBookmark(String itemName) {
        return BUConfig.get().bookmarks.stream().filter(bookmark -> bookmark.getName().equalsIgnoreCase(itemName)).findAny();
    }

    @RegisterWidget
    public static List<ItemSlotButtonWidget> getWidgets() {
        AccessorHandledScreen screen;
        ScreenInfo screenInfo;
        ArrayList<ItemSlotButtonWidget> widgets;
        block4: {
            block3: {
                widgets = new ArrayList<ItemSlotButtonWidget>();
                screenInfo = ScreenInfo.getCurrentScreenInfo();
                boolean isTargetScreen = screenInfo.inMenu(ScreenInfo.BazaarMenuType.BAZAAR_MAIN_PAGE);
                class_437 class_4372 = class_310.method_1551().field_1755;
                if (!(class_4372 instanceof AccessorHandledScreen)) break block3;
                screen = (AccessorHandledScreen)class_4372;
                if (isTargetScreen) break block4;
            }
            return Collections.emptyList();
        }
        ItemSlotButtonWidget.ScreenWidgetDimensions dimensions = ItemSlotButtonWidget.getSafeScreenDimensions(screen, screenInfo.getContainerName());
        int buttonSize = 18;
        int spacing = 4;
        int buttonX = dimensions.x() + dimensions.backgroundWidth() + spacing;
        int currentButtonY = dimensions.y() + spacing;
        ArrayList<Bookmark> bookmarks = BUConfig.get().bookmarks;
        for (int i = 0; i < bookmarks.size(); ++i) {
            class_1799 configuredItem = ((Bookmark)bookmarks.get(i)).getBookmarkedItemStack();
            int buttonIndex = i;
            class_1799 itemForButton = configuredItem == null ? class_1802.field_8077.method_7854() : configuredItem;
            Bookmark bookmark = (Bookmark)bookmarks.get(buttonIndex);
            class_5250 text = class_2561.method_43470((String)bookmark.getName()).method_27692(class_124.field_1067);
            OrderInfoContainer orderInfo = bookmark.getOrderInfo();
            orderInfo.updateMarketPrice();
            class_2583 style = class_2583.field_24360.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false));
            text.method_10852((class_2561)class_2561.method_43470((String)("\nBuy: " + Util.getPrettyString(orderInfo.getMarketPrice(PriceInfoContainer.PriceType.INSTASELL)) + " coins")).method_10862(style));
            text.method_10852((class_2561)class_2561.method_43470((String)("\nSell: " + Util.getPrettyString(orderInfo.getMarketPrice(PriceInfoContainer.PriceType.INSTABUY)) + " coins")).method_10862(style));
            ItemSlotButtonWidget button = new ItemSlotButtonWidget(buttonX, currentButtonY, buttonSize, buttonSize, SLOT_BUTTON_TEXTURES, btn -> {
                if (class_437.method_25442()) {
                    PlayerActionUtil.notifyAll("Removed " + bookmark.getName() + " bookmark from shift-click. Open Bazaar again to display changes.");
                    bookmark.onWidgetShiftClick();
                } else {
                    bookmark.onWidgetLeftClick();
                }
            }, itemForButton, (class_2561)text);
            widgets.add(button);
            currentButtonY += buttonSize + spacing;
        }
        return widgets;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public class_1799 getBookmarkedItemStack() {
        return this.bookmarkedItemStack;
    }

    @Generated
    public void setBookmarkedItemStack(class_1799 bookmarkedItemStack) {
        this.bookmarkedItemStack = bookmarkedItemStack;
    }

    @Generated
    public OrderInfoContainer getOrderInfo() {
        return this.orderInfo;
    }
}

