/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.ChestLoadedEvent;
import com.github.mkram17.bazaarutils.events.ReplaceItemEvent;
import com.github.mkram17.bazaarutils.events.SignOpenEvent;
import com.github.mkram17.bazaarutils.events.SlotClickEvent;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.misc.CustomItemButton;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.utils.GUIUtils;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.SoundUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.Option;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_6880;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class FlipHelper
extends CustomItemButton
implements BUListener {
    private static final int FLIP_ORDER_SLOT = 15;
    private static final Pattern PRICE_PATTERN = Pattern.compile("([\\d,.]+) coins");
    private static final Pattern VOLUME_PATTERN = Pattern.compile("([\\d,]+)");
    private static final String FLIP_ORDER_IDENTIFIER = "Flip Order";
    private static final String CANNOT_CANCEL_IDENTIFIER = "can't be flipped";
    private static final int LORE_LINE_VOLUME = 1;
    private static final int LORE_LINE_PRICE = 3;
    private boolean shouldAddToSign = false;
    private boolean enabled;
    private static final class_1792 BUTTON_ITEM = class_1802.field_42709;
    private BazaarOrder order;

    public FlipHelper(boolean enabled, int slotNumber) {
        this.enabled = enabled;
        this.slotNumber = slotNumber;
    }

    @EventHandler(priority=200)
    public void onChestLoaded(ChestLoadedEvent e) {
        if (!this.enabled) {
            return;
        }
        if (!FlipHelper.inCorrectScreen()) {
            this.resetState();
            return;
        }
        try {
            class_1799 flipOrderSign = this.getFlipSign(e.getItemStacks()).orElse(new class_1799((class_1935)class_1802.field_8077, 1));
            Optional<BazaarOrder> orderOptional = this.matchToUserOrder((class_9290)flipOrderSign.method_57353().method_58694(class_9334.field_49632));
            if (orderOptional.isEmpty()) {
                return;
            }
            this.order = orderOptional.get();
        }
        catch (Exception ex) {
            Util.notifyError("Error while trying to find flip item in Flip Helper", ex);
        }
    }

    @EventHandler
    public void onSlotClicked(SlotClickEvent event) {
        if (!this.enabled || event.slot.method_34266() != this.slotNumber || !FlipHelper.inCorrectScreen() || this.order == null) {
            return;
        }
        SoundUtil.playSound((class_6880<class_3414>)BUTTON_SOUND, 0.2f);
        GUIUtils.clickSlot(15, 0);
        this.shouldAddToSign = true;
    }

    @EventHandler
    public void onSignOpen(SignOpenEvent e) {
        if (!this.shouldAddToSign) {
            return;
        }
        this.handleFlip();
        this.shouldAddToSign = false;
    }

    @EventHandler(priority=200)
    public void replaceItemEvent(ReplaceItemEvent event) {
        if (!this.enabled || event.getSlotId() != this.slotNumber || !FlipHelper.inCorrectScreen() || this.order == null) {
            return;
        }
        class_1799 itemStack = new class_1799((class_1935)BUTTON_ITEM, 1);
        itemStack.method_57379(class_9334.field_49631, (Object)this.getButtonText());
        itemStack.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, (Object)this.getButtonStackSize());
        event.setReplacement(itemStack);
    }

    private class_2561 getButtonText() {
        double flipPrice = this.order.getFlipPrice();
        if (flipPrice == 0.0) {
            return class_2561.method_43470((String)"There are no competing sell offers.").method_27692(class_124.field_1064);
        }
        if (this.order == null) {
            return class_2561.method_43470((String)"Could not find order").method_27692(class_124.field_1064);
        }
        return class_2561.method_43470((String)("Flip order for " + Util.getPrettyString(flipPrice) + " coins")).method_27692(class_124.field_1064);
    }

    private String getButtonStackSize() {
        double flipPrice = this.order.getFlipPrice();
        if (this.order.getFlipPrice() == 0.0) {
            return "ANY";
        }
        if (this.order == null) {
            return "???";
        }
        return String.valueOf(Util.truncateNum(flipPrice));
    }

    private void resetState() {
        this.order = null;
        this.shouldAddToSign = false;
    }

    private void handleFlip() {
        double flipPrice = this.order.getFlipPrice();
        ScreenInfo previousScreen = ScreenInfo.getPreviousScreenInfos().getLast();
        if (this.order != null && flipPrice != 0.0 && previousScreen.inMenu(ScreenInfo.BazaarMenuType.FLIP_GUI)) {
            GUIUtils.setSignText(Double.toString(Util.truncateNum(flipPrice)), true);
            this.order.flipItem(flipPrice);
        }
    }

    private Optional<class_1799> getFlipSign(List<class_1799> chestItemStacks) {
        for (class_1799 itemStack : chestItemStacks) {
            class_9290 lore;
            if (itemStack == null || itemStack.method_7960() || !itemStack.method_7964().getString().contains(FLIP_ORDER_IDENTIFIER) || (lore = (class_9290)itemStack.method_57353().method_58694(class_9334.field_49632)) == null) continue;
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    private Optional<PriceInfoContainer> getOrderPriceInfo(class_9290 lore) {
        if (lore.comp_2400().size() <= 3) {
            return Optional.empty();
        }
        String priceLine = ((class_2561)lore.comp_2400().get(3)).getString();
        Matcher matcher = PRICE_PATTERN.matcher(priceLine);
        if (matcher.find()) {
            try {
                double orderPrice = Double.parseDouble(matcher.group(1).replace(",", ""));
                return Optional.of(new PriceInfoContainer(orderPrice, PriceInfoContainer.PriceType.INSTASELL));
            }
            catch (NumberFormatException e) {
                Util.notifyError("Error while trying to parse order price in Flip Helper", e);
            }
        }
        return Optional.empty();
    }

    private Optional<Integer> getVolumeUnclaimed(class_9290 lore) {
        if (lore.comp_2400().size() <= 1) {
            return Optional.empty();
        }
        String volumeLine = ((class_2561)lore.comp_2400().get(1)).getString();
        Matcher matcher = VOLUME_PATTERN.matcher(volumeLine);
        if (matcher.find()) {
            try {
                return Optional.of(Integer.parseInt(matcher.group(1).replace(",", "")));
            }
            catch (NumberFormatException e) {
                Util.notifyError("Error while trying to parse order volume in Flip Helper", e);
            }
        }
        return Optional.empty();
    }

    private Optional<BazaarOrder> matchToUserOrder(class_9290 lore) {
        Optional<PriceInfoContainer> priceInfoOpt = this.getOrderPriceInfo(lore);
        Optional<Integer> orderVolumeFilledOpt = this.getVolumeUnclaimed(lore);
        if (priceInfoOpt.isPresent() && orderVolumeFilledOpt.isPresent()) {
            PriceInfoContainer priceInfoContainer = priceInfoOpt.get();
            OrderInfoContainer tempOrder = new OrderInfoContainer(null, orderVolumeFilledOpt.get(), priceInfoContainer.getPricePerItem(), priceInfoContainer.getPriceType(), null);
            return tempOrder.findOrderInList(BUConfig.get().userOrders);
        }
        return Optional.empty();
    }

    private static boolean inCorrectScreen() {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        return screenInfo.inMenu(ScreenInfo.BazaarMenuType.FLIP_GUI) && !FlipHelper.inCancelOrderScreen();
    }

    private static boolean inCancelOrderScreen() {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (!(class_4372 instanceof class_476)) {
            return false;
        }
        class_476 inventory = (class_476)class_4372;
        try {
            return FlipHelper.cantBeFlippedLineIsPresent(inventory, 15);
        }
        catch (Exception ex) {
            Util.notifyError("Error while checking if in cancel screen", ex);
            return false;
        }
    }

    private static boolean cantBeFlippedLineIsPresent(class_476 inventory, int slot) {
        class_1799 itemStack = ((class_1707)inventory.method_17577()).method_7629().method_5438(slot);
        if (itemStack.method_7960()) {
            return false;
        }
        class_2561 customName = (class_2561)itemStack.method_58694(class_9334.field_49631);
        if (customName == null || !customName.getString().contains(FLIP_ORDER_IDENTIFIER)) {
            return false;
        }
        class_9290 lore = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (lore == null || lore.comp_2400().isEmpty()) {
            return false;
        }
        return Util.findComponentWith(lore.comp_2400(), CANNOT_CANCEL_IDENTIFIER) != null;
    }

    public Option<Boolean> createOption() {
        return super.createOption("Flip Helper", "Button in flip order menu to undercut market prices for items.", this::isEnabled, this::setEnabled);
    }

    @Override
    public void subscribe() {
        BazaarUtils.EVENT_BUS.subscribe((Object)this);
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public static class_1792 getBUTTON_ITEM() {
        return BUTTON_ITEM;
    }
}

