/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.data.BazaarData;
import com.github.mkram17.bazaarutils.events.ScreenChangeEvent;
import com.github.mkram17.bazaarutils.features.CustomOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.Option;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_746;
import net.minecraft.class_8646;
import net.minecraft.class_9015;

public class MaxBuyOrder
extends CustomOrder {
    private static final Pattern PURSE_PATTERN = Pattern.compile("(Purse|Piggy): (?<purse>[0-9,.]+)");
    private static double purse;

    public MaxBuyOrder(boolean enabled) {
        super(enabled);
    }

    @Override
    public void subscribe() {
        super.subscribe();
    }

    @EventHandler
    public void onScreenChange(ScreenChangeEvent event) {
        if (event.getNewScreen() == null || event.getOldScreen() == null) {
            return;
        }
        try {
            if (!MaxBuyOrder.inCorrectScreen(event)) {
                return;
            }
            class_1799 itemStack = MaxBuyOrder.getItemStack(event.getOldScreen());
            if (itemStack == null) {
                return;
            }
            class_310 client = class_310.method_1551();
            MaxBuyOrder.updatePurse(client);
            String name = itemStack.method_65130().getString();
            Optional<String> productID = BazaarData.findProductIdOptional(name);
            if (productID.isEmpty()) {
                return;
            }
            double cost = BazaarData.findItemPrice(productID.get(), PriceInfoContainer.PriceType.INSTASELL) + 0.1;
            int amountCanBuy = (int)Math.floor(purse / cost);
            super.setOrderAmount(Math.min(amountCanBuy, 71680));
        }
        catch (Exception e) {
            Util.notifyError("Could not parse coins from scoreboard text", e);
        }
    }

    private static boolean inCorrectScreen(ScreenChangeEvent event) {
        return (event.getNewScreen().method_25440().getString().contains("How many do you want?") || event.getNewScreen().method_25440().getString().contains("\u279c Insta")) && event.getNewScreen() instanceof class_476;
    }

    private static class_1799 getItemStack(class_437 previousScreen) {
        if (!(previousScreen instanceof class_476)) {
            return null;
        }
        class_476 containerScreen = (class_476)previousScreen;
        class_1799 itemStack = ((class_1707)containerScreen.method_17577()).method_7629().method_5438(13);
        if (itemStack.method_7960()) {
            Util.notifyError("Could not find item in previous container.", new Throwable());
            return null;
        }
        return itemStack;
    }

    private static void updatePurse(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_269 scoreboard = player.method_7327();
        class_266 objective = scoreboard.method_1189(class_8646.field_45157);
        if (objective == null) {
            return;
        }
        ObjectArrayList stringLines = new ObjectArrayList();
        for (class_9015 scoreHolder : scoreboard.method_1178()) {
            String line;
            class_268 team;
            if (!scoreboard.method_1166(scoreHolder).containsKey((Object)objective) || (team = scoreboard.method_1164(scoreHolder.method_5820())) == null || (line = team.method_1144().getString() + team.method_1136().getString()).trim().isEmpty()) continue;
            stringLines.add((Object)class_124.method_539((String)line));
        }
        purse = MaxBuyOrder.getPurse((List<String>)stringLines);
    }

    private static double getPurse(List<String> scoreboardLines) {
        for (String line : scoreboardLines) {
            Matcher matcher;
            if (!line.contains("Purse:") && !line.contains("Piggy:") || !(matcher = PURSE_PATTERN.matcher(line)).find()) continue;
            try {
                return Double.parseDouble(matcher.group("purse").replace(",", ""));
            }
            catch (NumberFormatException e) {
                Util.notifyError("Failed to parse purse from scoreboard", e);
            }
        }
        return -1.0;
    }

    @Override
    public Option<Boolean> createOption() {
        return super.createOption("Buy Max Button", "Buy order button for the maximum amount of an item you can buy with the coins in your purse.", this::isEnabled, this::setEnabled);
    }
}

