/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.misc.BUCompatibilityHelper;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import java.util.ArrayList;
import java.util.Collections;
import lombok.Generated;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;

public class StashMessages
implements BUListener {
    private boolean removeMessages;
    private boolean stashPreviouslyClaimed = false;
    private transient ArrayList<String> pastMessages = new ArrayList<String>(Collections.singleton(""));
    private static final String[] removeList = new String[]{" ", "materials stashed away", "type of material stashed", "to pick them up", "   "};

    public boolean shouldRemoveMessages() {
        return this.removeMessages;
    }

    public StashMessages(boolean removeMessages) {
        this.removeMessages = removeMessages;
    }

    @Override
    public void subscribe() {
        this.registerStashRemover();
        this.registerStashClaimDetector();
    }

    private void registerStashClaimDetector() {
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            if (message.getString().contains("You picked up") && message.getString().contains("from your material stash") && !this.stashPreviouslyClaimed) {
                this.stashPreviouslyClaimed = true;
                Util.scheduleConfigSave();
                Util.tickExecuteLater(2, () -> {
                    if (BUCompatibilityHelper.isAmecsReborn()) {
                        PlayerActionUtil.notifyAll("TIP - To claim stash more easily and quickly, use " + BazaarUtils.stashHelper.getUsage() + " to close the bazaar and claim stash! To disable stash messages, enable the \"Disable Stash Messages\" option in the Bazaar Utils config.");
                    } else {
                        PlayerActionUtil.notifyAll("TIP - To claim stash more easily and quickly, use download Amecs Reborn and use the Stash Helper keybinnd to close the bazaar and claim stash! To disable stash messages, enable the \"Disable Stash Messages\" option in the Bazaar Utils config.");
                    }
                });
            }
        });
    }

    private void registerStashRemover() {
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            boolean removeCurrentMessage;
            if (!BUConfig.get().stashMessages.shouldRemoveMessages() || message.getString().contains("Mana")) {
                return true;
            }
            String currentMessageString = message.getString();
            int currentMessageRoleIndex = StashMessages.indexOfMessage(currentMessageString);
            if (this.pastMessages == null) {
                this.pastMessages = new ArrayList();
            }
            if (currentMessageRoleIndex == -1) {
                this.pastMessages.clear();
                removeCurrentMessage = false;
            } else if (currentMessageRoleIndex == this.pastMessages.size()) {
                this.pastMessages.add(currentMessageString);
                removeCurrentMessage = true;
                if (this.pastMessages.size() == removeList.length) {
                    this.pastMessages.clear();
                }
            } else {
                this.pastMessages.clear();
                removeCurrentMessage = false;
                if (currentMessageRoleIndex == 0) {
                    this.pastMessages.add(currentMessageString);
                    removeCurrentMessage = true;
                }
            }
            return !removeCurrentMessage;
        });
    }

    private static int indexOfMessage(String messageContent) {
        if (messageContent.equals(" ")) {
            return 0;
        }
        if (messageContent.equals("  ")) {
            return 4;
        }
        if (messageContent.contains("types of materials stashed")) {
            return 2;
        }
        for (int i = removeList.length - 2; i >= 1; --i) {
            if (!messageContent.contains(removeList[i])) continue;
            return i;
        }
        return -1;
    }

    public Option<Boolean> createOption() {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Disable Stash Messages")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"When this option is ON, messages reminding you to pick up your stash will no longer appear in chat.")})).binding((Object)false, this::shouldRemoveMessages, this::setRemoveMessages).controller(BUConfigGui::createBooleanController).build();
    }

    @Generated
    public void setRemoveMessages(boolean removeMessages) {
        this.removeMessages = removeMessages;
    }

    @Generated
    public void setStashPreviouslyClaimed(boolean stashPreviouslyClaimed) {
        this.stashPreviouslyClaimed = stashPreviouslyClaimed;
    }

    @Generated
    public boolean isStashPreviouslyClaimed() {
        return this.stashPreviouslyClaimed;
    }
}

