/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.misc;

import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.hysky.skyblocker.config.SkyblockerConfig;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;

public class BUCompatibilityHelper {
    private static final String REI_MOD_ID = "roughlyenoughitems";
    public static final String SKYBLOCKER_MOD_ID = "skyblocker";
    private static final String REI_CONFIG_FILENAME = "roughlyenoughitems/config.json5";
    private static final String REI_CONFIG_SECTION = "appearance";
    private static final String REI_CONFIG_FIELD = "horizontalEntriesBoundariesColumns";
    private static final int HORIZONTALENTRIESBOUNDARIESCOLUMS_VALUE = 16;
    public static final String AMECS_MODID = "amecs-reborn";
    public static final String FIRMAMENT_MODID = "firmament";
    private static boolean amecsReborn = false;
    private static final Gson GSON_WRITER = new GsonBuilder().setPrettyPrinting().create();

    public static void initializePatches() {
        if (FabricLoader.getInstance().isModLoaded(REI_MOD_ID)) {
            Util.logMessage("REI detected. Attempting to modify REI config.");
            BUCompatibilityHelper.modifyReiConfigWithGson();
        }
        if (FabricLoader.getInstance().isModLoaded(AMECS_MODID)) {
            amecsReborn = true;
        }
    }

    private static void modifyReiConfigWithGson() {
        JsonObject rootObject;
        Path reiConfigFile;
        block25: {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            reiConfigFile = configDir.resolve(REI_CONFIG_FILENAME);
            if (!Files.exists(reiConfigFile, new LinkOption[0])) {
                Util.notifyError("Could not find REI config file at: " + String.valueOf(reiConfigFile), new Throwable());
                return;
            }
            rootObject = null;
            try (BufferedReader reader = Files.newBufferedReader(reiConfigFile, StandardCharsets.UTF_8);){
                JsonElement rootElement = JsonParser.parseReader((Reader)reader);
                if (rootElement.isJsonObject()) {
                    rootObject = rootElement.getAsJsonObject();
                    break block25;
                }
                Util.notifyError("REI config root is not a JSON object: " + String.valueOf(reiConfigFile), new Throwable());
                return;
            }
            catch (JsonSyntaxException e) {
                Util.notifyError("Failed to parse REI config file (likely due to non-standard JSON5 features like comments that Gson couldn't handle, or actual syntax errors): " + String.valueOf(reiConfigFile), e);
                return;
            }
            catch (IOException e) {
                Util.notifyError("Failed to read REI config file: " + String.valueOf(reiConfigFile), e);
                return;
            }
        }
        try {
            JsonObject appearanceObject;
            if (rootObject != null && rootObject.has(REI_CONFIG_SECTION) && rootObject.get(REI_CONFIG_SECTION).isJsonObject()) {
                appearanceObject = rootObject.getAsJsonObject(REI_CONFIG_SECTION);
                if (appearanceObject.has(REI_CONFIG_FIELD)) {
                    JsonElement currentValue = appearanceObject.get(REI_CONFIG_FIELD);
                    Util.logMessage("Current REI value for 'appearance.horizontalEntriesBoundariesColumns': " + String.valueOf(currentValue));
                } else {
                    Util.notifyError("Key 'appearance.horizontalEntriesBoundariesColumns' not found in REI config.", new Throwable());
                }
            } else {
                Util.notifyError("REI config structure unexpected. Missing 'appearance' object.", new Throwable());
                return;
            }
            appearanceObject.addProperty(REI_CONFIG_FIELD, (Number)16);
            Util.logMessage("Set REI value for 'appearance.horizontalEntriesBoundariesColumns' to: 16");
        }
        catch (Exception e) {
            Util.notifyError("Error modifying the JSON structure in memory.", e);
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(reiConfigFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON_WRITER.toJson((JsonElement)rootObject, (Appendable)writer);
            Util.logMessage("Successfully saved modified REI config (comments removed): " + String.valueOf(reiConfigFile));
        }
        catch (IOException e) {
            Util.notifyError("Failed to write modified REI config file: " + String.valueOf(reiConfigFile), e);
        }
    }

    public static boolean isSkyblockerLoaded() {
        return FabricLoader.getInstance().isModLoaded(SKYBLOCKER_MOD_ID);
    }

    public static void setSkyblockerBazaarOverlayValue(boolean enabled) {
        if (!BUCompatibilityHelper.isSkyblockerLoaded()) {
            Util.logMessage("Skyblocker not loaded, cannot change its config.");
            return;
        }
        if (enabled) {
            if (BUCompatibilityHelper.isSkyblockerBazaarOverlayEnabled()) {
                Util.logMessage("Skyblocker Bazaar Overlay already enabled.");
                return;
            }
            BUCompatibilityHelper.tryEnableSkyblockerBazaarOverlay();
        } else {
            if (!BUCompatibilityHelper.isSkyblockerBazaarOverlayEnabled()) {
                Util.logMessage("Skyblocker Bazaar Overlay already disabled.");
                return;
            }
            BUCompatibilityHelper.tryDisableSkyblockerBazaarOverlay();
        }
    }

    public static boolean isSkyblockerBazaarOverlayEnabled() {
        if (!BUCompatibilityHelper.isSkyblockerLoaded()) {
            Util.logMessage("Skyblocker not loaded, cannot check its config.");
            return false;
        }
        try {
            SkyblockerConfig skyblockerConfig = SkyblockerConfigManager.get();
            return skyblockerConfig.uiAndVisuals.searchOverlay.enableBazaar;
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError e) {
            Util.notifyError("Failed to access Skyblocker config setting.", e);
            return false;
        }
    }

    private static void tryDisableSkyblockerBazaarOverlay() {
        if (!BUCompatibilityHelper.isSkyblockerLoaded()) {
            Util.logMessage("Skyblocker not loaded, cannot change its config.");
            return;
        }
        try {
            boolean currentValue = BUCompatibilityHelper.isSkyblockerBazaarOverlayEnabled();
            PlayerActionUtil.notifyAll("Skyblocker Bazaar Overlay current state: " + currentValue, Util.notificationTypes.GUI);
            if (currentValue) {
                SkyblockerConfigManager.update(config -> {
                    config.uiAndVisuals.searchOverlay.enableBazaar = false;
                });
                PlayerActionUtil.notifyAll("Attempting to disable Skyblocker Bazaar Overlay...", Util.notificationTypes.GUI);
                PlayerActionUtil.notifyAll("Disabled Skyblocker Bazaar search overlay.", Util.notificationTypes.GUI);
            } else {
                PlayerActionUtil.notifyAll("Skyblocker Bazaar Overlay already disabled.", Util.notificationTypes.GUI);
            }
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError e) {
            Util.notifyError("Failed to access or modify Skyblocker config setting.", e);
        }
    }

    private static void tryEnableSkyblockerBazaarOverlay() {
        if (!FabricLoader.getInstance().isModLoaded(SKYBLOCKER_MOD_ID)) {
            Util.logMessage("Skyblocker not loaded, cannot enable its config setting.");
            return;
        }
        try {
            if (!BUCompatibilityHelper.isSkyblockerBazaarOverlayEnabled()) {
                Util.logMessage("Attempting to enable Skyblocker Bazaar Overlay...");
                SkyblockerConfigManager.update(x -> {
                    x.uiAndVisuals.searchOverlay.enableBazaar = true;
                });
                PlayerActionUtil.notifyAll("Enabled Skyblocker Bazaar search overlay.", Util.notificationTypes.GUI);
            } else {
                Util.logMessage("Skyblocker Bazaar Overlay already enabled.");
            }
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError e) {
            Util.notifyError("Failed to access or modify Skyblocker config setting (enable attempt).", e);
        }
    }

    @Generated
    public static boolean isAmecsReborn() {
        return amecsReborn;
    }
}

