/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.misc.orderinfo;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.BazaarDataUpdateEvent;
import com.github.mkram17.bazaarutils.events.UserOrdersChangeEvent;
import com.github.mkram17.bazaarutils.features.OutbidOrderHandler;
import com.github.mkram17.bazaarutils.misc.orderinfo.ItemInfo;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.SoundUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import meteordevelopment.orbit.EventHandler;
import meteordevelopment.orbit.ICancellable;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BazaarOrder
extends OrderInfoContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BazaarOrder.class);
    public static final int OUTBID_ORDER_NOTIFICATIONS = 3;
    private OrderInfoContainer.Statuses fillStatus = OrderInfoContainer.Statuses.SET;
    private int amountClaimed = 0;
    private int amountFilled = 0;

    public BazaarOrder(String name, Integer volume, Double pricePerItem, PriceInfoContainer.PriceType priceType) {
        this(name, volume, pricePerItem, priceType, null);
    }

    public BazaarOrder(String name, Integer volume, Double pricePerItem, PriceInfoContainer.PriceType priceType, ItemInfo itemInfo) {
        super(name, volume, pricePerItem, priceType, itemInfo);
        this.startTracking();
    }

    private void startTracking() {
        this.handleOutbidStatusChange();
        this.subscribe();
        this.scheduleHealthCheck();
        this.updateMarketPrice();
    }

    @EventHandler
    private void onDataUpdate(BazaarDataUpdateEvent e) {
        this.updateMarketPrice();
        this.handleOutbidStatusChange();
    }

    @EventHandler
    private void onUserOrderChange(UserOrdersChangeEvent e) {
        if (e.getChangeType() == UserOrdersChangeEvent.ChangeTypes.REMOVE || e.getOrder() != this) {
            return;
        }
        this.updateMarketPrice();
        this.handleOutbidStatusChange();
    }

    private void handleOutbidStatusChange() {
        Optional<OrderInfoContainer.Statuses> outbidOptional = this.findOutbidStatus();
        if (outbidOptional.isEmpty()) {
            return;
        }
        OrderInfoContainer.Statuses newStatus = outbidOptional.get();
        if (this.outbidStatus != newStatus) {
            this.outbidStatus = newStatus;
            this.onOutbid(newStatus == OrderInfoContainer.Statuses.OUTBID);
        }
    }

    private void onOutbid(boolean isOutbid) {
        boolean shouldNotifyUser = BUConfig.get().outbidOrderHandler.isNotifyOutbid();
        boolean shouldPlayNotificationSound = BUConfig.get().outbidOrderHandler.isNotificationSound();
        boolean shouldAutoOpenBazaar = BUConfig.get().outbidOrderHandler.isAutoOpenEnabled();
        if (!shouldNotifyUser || !BUConfig.get().userOrders.contains(this)) {
            return;
        }
        if (this.getFillStatus() == OrderInfoContainer.Statuses.FILLED) {
            return;
        }
        if (isOutbid) {
            class_5250 message = OutbidOrderHandler.getOutbidMessage(this);
            if (BUConfig.get().developerMode) {
                message.method_10852((class_2561)class_2561.method_43470((String)(". Market Price: " + this.getMarketPrice(this.getPriceType()) + " Order Price: " + this.getPricePerItem())));
            }
            if (shouldAutoOpenBazaar) {
                this.openBazaar();
            }
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (shouldPlayNotificationSound && player != null) {
                SoundUtil.notifyMultipleTimes(3);
            }
            Util.tickExecuteLater(2, () -> PlayerActionUtil.notifyChatCommand(message, "managebazaarorders"));
        } else if (this.getOutbidStatus() == OrderInfoContainer.Statuses.COMPETITIVE) {
            class_5250 message = OutbidOrderHandler.getCompetitiveMessage(this);
            Util.tickExecuteLater(2, () -> PlayerActionUtil.notifyAll((class_2561)message));
        } else {
            class_5250 message = OutbidOrderHandler.getMatchedMessage(this);
            Util.tickExecuteLater(2, () -> PlayerActionUtil.notifyAll((class_2561)message));
        }
    }

    public void openBazaar() {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        if (screenInfo.inBazaar()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            for (int i = 3; i >= 1; --i) {
                try {
                    if (i == 3) {
                        PlayerActionUtil.notifyAll("Opening bazaar in 3");
                    } else {
                        PlayerActionUtil.notifyAll(String.valueOf(i));
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            PlayerActionUtil.runCommand("managebazaarorders");
        });
    }

    public int getIndex() {
        return BUConfig.get().userOrders.indexOf(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(this.name).append("[").append(this.getIndex()).append("]");
        if (this.amountClaimed != 0) {
            sb.append(", amount claimed: ").append(this.amountClaimed);
        }
        sb.append(", type: ").append(this.getPriceType().getString());
        if (this.fillStatus == OrderInfoContainer.Statuses.FILLED) {
            sb.append(", status: ").append((Object)this.fillStatus);
        }
        sb.append(")");
        return sb.toString();
    }

    public void flipItem(double newPrice) {
        this.flipPrices(newPrice);
        this.updateMarketPrice();
        this.amountFilled = 0;
        this.fillStatus = OrderInfoContainer.Statuses.SET;
        BazaarUtils.EVENT_BUS.post((ICancellable)new UserOrdersChangeEvent(UserOrdersChangeEvent.ChangeTypes.UPDATE, this));
    }

    public double getFlipPrice() {
        this.updateMarketPrice();
        Double marketPrice = this.getMarketPrice(this.priceType);
        Double marketOppositePrice = this.getMarketPrice(this.priceType.getOpposite());
        if (marketPrice == 0.0) {
            return 0.0;
        }
        if (this.getPriceType() == PriceInfoContainer.PriceType.INSTABUY) {
            return marketOppositePrice + 0.1;
        }
        return marketOppositePrice - 0.1;
    }

    public void setAmountFilled(int amountFilled) {
        this.amountFilled = amountFilled;
        if (this.amountFilled >= this.volume) {
            this.setFilled();
        } else {
            this.fillStatus = OrderInfoContainer.Statuses.SET;
        }
    }

    public void setFilled() {
        this.amountFilled = this.volume;
        this.fillStatus = OrderInfoContainer.Statuses.FILLED;
    }

    public void removeFromWatchedItems() {
        if (!BUConfig.get().userOrders.remove(this)) {
            PlayerActionUtil.notifyAll("Error removing " + this.name + " from watched items. Item couldn't be found.");
        }
        BazaarUtils.EVENT_BUS.post((ICancellable)new UserOrdersChangeEvent(UserOrdersChangeEvent.ChangeTypes.REMOVE, this));
        Util.scheduleConfigSave();
    }

    @Generated
    public OrderInfoContainer.Statuses getFillStatus() {
        return this.fillStatus;
    }

    @Generated
    public void setFillStatus(OrderInfoContainer.Statuses fillStatus) {
        this.fillStatus = fillStatus;
    }

    @Generated
    public int getAmountClaimed() {
        return this.amountClaimed;
    }

    @Generated
    public void setAmountClaimed(int amountClaimed) {
        this.amountClaimed = amountClaimed;
    }

    @Generated
    public int getAmountFilled() {
        return this.amountFilled;
    }
}

