/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.misc.orderinfo;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.data.BazaarData;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.ItemInfo;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.utils.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class OrderInfoContainer
extends PriceInfoContainer
implements BUListener {
    private static final double DEFAULT_TOLERANCE = 0.9;
    private static final double TOTAL_PRICE_ROUNDING_THRESHOLD = 10000.0;
    protected final String name;
    protected final Integer volume;
    protected String productID;
    protected Statuses outbidStatus;
    protected double tolerance;
    private ItemInfo itemInfo;

    public OrderInfoContainer(@Nullable String name, @Nullable Integer volume, @Nullable Double pricePerItem, @Nullable PriceInfoContainer.PriceType priceType, @Nullable ItemInfo itemInfo) {
        super(pricePerItem, priceType);
        this.volume = volume;
        this.name = name;
        this.tolerance = this.calculateTolerance();
        this.itemInfo = itemInfo;
        this.validateProduct();
        BazaarData.findProductIdOptional(name).ifPresent(productId -> {
            this.productID = productId;
        });
        this.findOutbidStatus().ifPresent(status -> {
            this.outbidStatus = status;
        });
    }

    private double calculateTolerance() {
        if (this.pricePerItem == null || this.volume == null) {
            return 0.9;
        }
        if (this.pricePerItem * (double)this.volume.intValue() < 10000.0) {
            return 0.0;
        }
        double priceMaximumInaccuracy = 0.9 / (double)this.volume.intValue();
        return (double)Math.round(priceMaximumInaccuracy * 10.0) / 10.0;
    }

    public static boolean isValidName(String itemName) {
        return itemName != null && BazaarData.findProductId(itemName) != null;
    }

    public void updateMarketPrice() {
        this.updateMarketPrice(this.productID);
    }

    private void validateProduct() {
        if (this.productID == null && this.name != null && !this.fixProductID()) {
            Util.notifyError("Product ID for " + this.name + " is null. This may cause issues", new Throwable());
        }
    }

    protected void scheduleHealthCheck() {
        long START_DELAY_SECONDS = 60L;
        long CHECK_INTERVAL_SECONDS = 30L;
        BazaarUtils.BUExecutorService.scheduleAtFixedRate(() -> {
            if (!this.fixProductID()) {
                Util.logError("Could not fix product ID for " + this.name + ". This may cause the mod to work improperly.", new Throwable());
            }
        }, START_DELAY_SECONDS, CHECK_INTERVAL_SECONDS, TimeUnit.SECONDS);
    }

    private boolean fixProductID() {
        if (this.isProductIDHealthy()) {
            return true;
        }
        Optional<String> newProductID = BazaarData.findProductIdOptional(this.name);
        if (newProductID.isPresent()) {
            Util.logMessage("Successfully fixed product ID for " + this.name + ": " + String.valueOf(newProductID));
            return true;
        }
        Util.logError("While refinding product id, could not find product ID for " + this.name, null);
        return false;
    }

    private boolean isProductIDHealthy() {
        return this.productID != null && !this.productID.isEmpty() && !BazaarData.findItemPriceOptional(this.productID, this.getPriceType()).isEmpty();
    }

    public Optional<Statuses> findOutbidStatus() {
        if (this.pricePerItem == null || !this.isProductIDHealthy()) {
            return Optional.empty();
        }
        this.updateMarketPrice();
        double marketPrice = this.getMarketPrice(this.getPriceType());
        OptionalInt orderCountOpt = BazaarData.getOrderCountOptional(this.productID, this.getPriceType(), this.getPricePerItem());
        if (orderCountOpt.isEmpty()) {
            return Optional.empty();
        }
        int orderCount = orderCountOpt.getAsInt();
        if (this.priceType == PriceInfoContainer.PriceType.INSTASELL) {
            if (this.pricePerItem > marketPrice) {
                return Optional.of(Statuses.COMPETITIVE);
            }
            if (this.pricePerItem < marketPrice) {
                return Optional.of(Statuses.OUTBID);
            }
            if (orderCount > 1) {
                return Optional.of(Statuses.MATCHED);
            }
        } else {
            if (this.pricePerItem < marketPrice) {
                return Optional.of(Statuses.COMPETITIVE);
            }
            if (this.pricePerItem > marketPrice) {
                return Optional.of(Statuses.OUTBID);
            }
            if (orderCount > 1) {
                return Optional.of(Statuses.MATCHED);
            }
        }
        return Optional.of(Statuses.COMPETITIVE);
    }

    @Override
    public void subscribe() {
        BazaarUtils.EVENT_BUS.subscribe((Object)this);
    }

    public boolean isSimilarTo(BazaarOrder other, boolean isStrict) {
        String otherOrderName = other.getName();
        Double otherOrderPrice = other.getPricePerItem();
        Integer otherOrderVolume = other.getVolume();
        int otherOrderAmountUnclaimed = other.getAmountFilled() - other.getAmountClaimed();
        PriceInfoContainer.PriceType priceType = other.getPriceType();
        if (isStrict) {
            return this.isStrictlySimilarTo(otherOrderName, otherOrderPrice, otherOrderVolume, priceType);
        }
        return this.isLooselySimilarTo(otherOrderName, otherOrderPrice, otherOrderVolume, otherOrderAmountUnclaimed, priceType);
    }

    private boolean isStrictlySimilarTo(String otherOrderName, Double otherOrderPrice, Integer otherOrderVolume, PriceInfoContainer.PriceType priceType) {
        return !(!this.areAnyNull(this.pricePerItem, otherOrderPrice) && !this.isSimilarPrice(otherOrderPrice) || !this.areAnyNull(this.volume, otherOrderVolume) && !this.volume.equals(otherOrderVolume) || !this.areAnyNull(this.name, otherOrderName) && !this.name.equalsIgnoreCase(otherOrderName) || !this.areAnyNull(new Object[]{this.priceType, priceType}) && this.priceType != priceType);
    }

    private boolean isLooselySimilarTo(String otherOrderName, Double otherOrderPrice, Integer otherOrderVolume, int otherOrderAmountUnclaimed, PriceInfoContainer.PriceType priceType) {
        return !(!this.areAnyNull(this.pricePerItem, otherOrderPrice) && !this.isSimilarPrice(otherOrderPrice) || !this.areAnyNull(this.volume, otherOrderVolume) && !Util.genericIsSimilarValue(this.getVolume().intValue(), otherOrderVolume.intValue(), 0.05 * (double)otherOrderVolume.intValue()) && !this.getVolume().equals(otherOrderAmountUnclaimed) || !this.areAnyNull(this.name, otherOrderName) && !this.getName().equalsIgnoreCase(otherOrderName) || !this.areAnyNull(new Object[]{this.priceType, priceType}) && this.getPriceType() != priceType);
    }

    private boolean areAnyNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    public Optional<BazaarOrder> findOrderInList(List<BazaarOrder> list) {
        List<BazaarOrder> itemList = this.findAllMatchesInList(list);
        if (itemList.size() > 1) {
            return Optional.of(this.findBestMatch(itemList));
        }
        if (itemList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(itemList.getFirst());
    }

    public List<BazaarOrder> findAllMatchesInList(List<BazaarOrder> list) {
        ArrayList<BazaarOrder> itemList = new ArrayList<BazaarOrder>();
        for (BazaarOrder item : list) {
            if (!this.isSimilarTo(item, true)) continue;
            itemList.add(item);
        }
        if (itemList.isEmpty()) {
            for (BazaarOrder item : list) {
                if (!this.isSimilarTo(item, false)) continue;
                itemList.add(item);
            }
        }
        return itemList;
    }

    private boolean isSimilarPrice(double price) {
        return Util.genericIsSimilarValue(this.pricePerItem, price, this.tolerance + price * 0.01);
    }

    public static <T> List<T> getVariables(Function<BazaarOrder, T> variable) {
        return BUConfig.get().userOrders.stream().map(variable).toList();
    }

    private BazaarOrder findBestMatch(List<BazaarOrder> list) {
        return list.stream().min(this.getVolumeThenPriceComparator()).orElse(list.getFirst());
    }

    private Comparator<BazaarOrder> getVolumeThenPriceComparator() {
        Comparator<BazaarOrder> volumeComparator = Comparator.comparingDouble(order -> {
            if (this.areAnyNull(this.getVolume(), order.getVolume())) {
                return Double.MAX_VALUE;
            }
            return Math.abs(order.getVolume() - this.getVolume());
        });
        Comparator<BazaarOrder> priceComparator = Comparator.comparingDouble(order -> {
            if (this.areAnyNull(this.pricePerItem, order.getPricePerItem())) {
                return Double.MAX_VALUE;
            }
            return Math.abs(order.getPricePerItem() - this.pricePerItem);
        });
        return volumeComparator.thenComparing(priceComparator);
    }

    public String toString() {
        return "(name: " + this.name + ", price:" + this.pricePerItem + ", volume: " + this.volume + ")";
    }

    public BazaarOrder toBazaarOrder() {
        return new BazaarOrder(this.name, this.volume, this.pricePerItem, this.priceType, null);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getVolume() {
        return this.volume;
    }

    @Generated
    public String getProductID() {
        return this.productID;
    }

    @Generated
    public Statuses getOutbidStatus() {
        return this.outbidStatus;
    }

    @Generated
    public double getTolerance() {
        return this.tolerance;
    }

    @Generated
    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    @Generated
    public ItemInfo getItemInfo() {
        return this.itemInfo;
    }

    @Generated
    public void setItemInfo(ItemInfo itemInfo) {
        this.itemInfo = itemInfo;
    }

    public static enum Statuses {
        SET,
        FILLED,
        OUTBID,
        COMPETITIVE,
        MATCHED;

    }
}

