/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.utils;

import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.data.BazaarData;
import com.github.mkram17.bazaarutils.features.CustomOrder;
import com.github.mkram17.bazaarutils.features.OutbidOrderHandler;
import com.github.mkram17.bazaarutils.features.restrictsell.RestrictSell;
import com.github.mkram17.bazaarutils.features.restrictsell.RestrictSellControl;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.ResourceManager;
import com.github.mkram17.bazaarutils.utils.Util;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;

public class BUCommands {
    private static final List<LiteralArgumentBuilder<FabricClientCommandSource>> developerCommands = List.of((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(BUCommands::executeRemove)), (LiteralArgumentBuilder)ClientCommandManager.literal((String)"info").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(BUCommands::executeInfo)), (LiteralArgumentBuilder)ClientCommandManager.literal((String)"outdated").executes(source -> {
        for (BazaarOrder item : OutbidOrderHandler.getOutbidOrders()) {
            PlayerActionUtil.notifyAll(item.getName() + " is outdated. Market Price: " + item.getInstaSellPrice() + " Order Price: " + item.getPricePerItem());
        }
        return 1;
    }), (LiteralArgumentBuilder)ClientCommandManager.literal((String)"convertname").then(ClientCommandManager.argument((String)"item name", (ArgumentType)StringArgumentType.string()).executes(context -> {
        String name = StringArgumentType.getString((CommandContext)context, (String)"item name").replaceAll("_", " ");
        String productID = BazaarData.findProductId(name);
        if (productID == null) {
            PlayerActionUtil.notifyAll("Could not find product ID for " + name);
        } else {
            PlayerActionUtil.notifyAll(name + ": " + productID);
        }
        return 1;
    })), (LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").executes(context -> {
        PlayerActionUtil.notifyAll(BazaarOrder.getVariables(OrderInfoContainer::getName).toString());
        return 1;
    }));
    private static final LiteralArgumentBuilder<FabricClientCommandSource> bazaarutils = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"bazaarutils").executes(context -> {
        BUConfig.openGUI();
        return 1;
    });

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        bazaarutils.then(ClientCommandManager.literal((String)"help").executes(context -> {
            PlayerActionUtil.notifyAll("Commands: /bu or /bazaarutils to open settings gui. \n---------------------------\n /bu tax {amount} to set bazaar tax. This is important for the mod to function correctly. /bu customorders to see current Custom Orders. /bu customorder {order amount} {slot number} to make new Custom Order /bu customorder remove {customorder number} to remove Custom Order (find number by using /bu customorders) \n---------------------------\n  ");
            return 1;
        }));
        bazaarutils.then(ClientCommandManager.literal((String)"tax").then(ClientCommandManager.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)1.25)).executes(context -> {
            BUConfig.get().bzTax = DoubleArgumentType.getDouble((CommandContext)context, (String)"amount") / 100.0;
            return 1;
        })));
        bazaarutils.then(ClientCommandManager.literal((String)"discord").executes(context -> {
            class_310 client = class_310.method_1551();
            client.method_63588(() -> ((FabricClientCommandSource)context.getSource()).getClient().method_1507((class_437)new class_407(confirmed -> {
                if (confirmed) {
                    try {
                        class_156.method_668().method_673(new URI("https://discord.gg/xDKjvm5hQd"));
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                class_310.method_1551().method_1507(null);
            }, "https://discord.gg/xDKjvm5hQd", true)));
            return 1;
        }));
        bazaarutils.then(ClientCommandManager.literal((String)"developer").executes(context -> {
            BUConfig.get().developerMode = !BUConfig.get().developerMode;
            Util.scheduleConfigSave();
            PlayerActionUtil.notifyAll(BUConfig.get().developerMode ? "Developer mode enabled." : "Developer mode disabled. Restart for all changes to take effect");
            if (BUConfig.get().developerMode) {
                BUCommands.registerDeveloperCommands(dispatcher);
            }
            return 1;
        }));
        bazaarutils.then(ClientCommandManager.literal((String)"customorder").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"order amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)71680)).then(ClientCommandManager.argument((String)"slot number", (ArgumentType)IntegerArgumentType.integer((int)1, (int)36)).executes(context -> {
            int orderAmount = IntegerArgumentType.getInteger((CommandContext)context, (String)"order amount");
            int slotNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"slot number");
            if (orderAmount < 1 || orderAmount > 71679) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Order amount must be 1-71,679"));
                return 0;
            }
            if (slotNumber < 1 || slotNumber > 36) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Slot number must be 1-36"));
                return 0;
            }
            CustomOrder orderToAdd = new CustomOrder(true, orderAmount, slotNumber - 1, CustomOrder.getNextColoredPane());
            BUConfig.get().customOrders.add(orderToAdd);
            PlayerActionUtil.notifyAll("Added order for " + orderToAdd.getOrderAmount() + " in slot number " + slotNumber);
            Util.scheduleConfigSave();
            return 1;
        })))));
        bazaarutils.then(ClientCommandManager.literal((String)"customorder").then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"order number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int orderNum = IntegerArgumentType.getInteger((CommandContext)context, (String)"order number") - 1;
            if (BUConfig.get().customOrders.size() < orderNum) {
                PlayerActionUtil.notifyAll("There is no Custom Order #" + orderNum + ". The Custom Order # is based on the order they are displayed in the config.");
                return 0;
            }
            CustomOrder customOrder = BUConfig.get().customOrders.get(orderNum);
            if (customOrder.getOrderAmount() == 71680) {
                PlayerActionUtil.notifyAll("Cannot remove Max Buy Order.");
                return 0;
            }
            PlayerActionUtil.notifyAll("Removed Custom Order for " + BUConfig.get().customOrders.get(orderNum).getOrderAmount());
            BUConfig.get().customOrders.get(orderNum).remove();
            Util.scheduleConfigSave();
            return 1;
        }))));
        bazaarutils.then(ClientCommandManager.literal((String)"rule").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").then(ClientCommandManager.literal((String)"volume").then(ClientCommandManager.argument((String)"limit", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(context -> {
            double limit = DoubleArgumentType.getDouble((CommandContext)context, (String)"limit");
            BUConfig.get().restrictSell.addRule(RestrictSell.restrictBy.VOLUME, limit);
            Util.scheduleConfigSave();
            PlayerActionUtil.notifyAll("Added rule: VOLUME: " + limit);
            return 1;
        })))).then(ClientCommandManager.literal((String)"price").then(ClientCommandManager.argument((String)"limit", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(context -> {
            double limit = DoubleArgumentType.getDouble((CommandContext)context, (String)"limit");
            BUConfig.get().restrictSell.addRule(RestrictSell.restrictBy.PRICE, limit);
            Util.scheduleConfigSave();
            PlayerActionUtil.notifyAll("Added rule: PRICE: " + limit);
            return 1;
        })))).then(ClientCommandManager.literal((String)"name").then(ClientCommandManager.argument((String)"itemName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"itemName");
            BUConfig.get().restrictSell.addRule(RestrictSell.restrictBy.NAME, name);
            Util.scheduleConfigSave();
            PlayerActionUtil.notifyAll("Added rule: NAME: " + name);
            return 1;
        })))));
        bazaarutils.then(ClientCommandManager.literal((String)"rule").then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"rule number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int restrictNum = IntegerArgumentType.getInteger((CommandContext)context, (String)"rule number") - 1;
            RestrictSellControl rule = BUConfig.get().restrictSell.getControls().get(restrictNum);
            if (rule == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Invalid rule number. Check the order in /bu"));
            }
            if (rule.getRule() != null) {
                PlayerActionUtil.notifyAll(rule.getRule() == RestrictSell.restrictBy.NAME ? "Removed rule: NAME: " + rule.getName() : "Removed rule: " + String.valueOf((Object)rule.getRule()) + ": " + rule.getAmount());
            }
            BUConfig.get().restrictSell.getControls().remove(restrictNum);
            Util.scheduleConfigSave();
            return 1;
        }))));
        bazaarutils.then(ClientCommandManager.literal((String)"updateresources").executes(context -> {
            PlayerActionUtil.notifyAll("Checking for resource updates...");
            ResourceManager.checkForUpdates(true);
            return 1;
        }));
        if (BUConfig.get().developerMode) {
            BUCommands.registerDeveloperCommands(dispatcher);
        }
        LiteralCommandNode bazaarutilsNode = dispatcher.register(bazaarutils);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bu").executes(context -> bazaarutils.getCommand().run(context))).redirect((CommandNode)bazaarutilsNode));
    }

    private static void registerDeveloperCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        for (LiteralArgumentBuilder<FabricClientCommandSource> command : developerCommands) {
            bazaarutils.then(command);
        }
        dispatcher.register(bazaarutils);
    }

    private static int executeRemove(CommandContext<FabricClientCommandSource> context) {
        int index = IntegerArgumentType.getInteger(context, (String)"index");
        BazaarOrder bazaarOrder = BUConfig.get().userOrders.get(index);
        bazaarOrder.removeFromWatchedItems();
        PlayerActionUtil.notifyAll("Removed " + String.valueOf(bazaarOrder), Util.notificationTypes.COMMAND);
        return 1;
    }

    private static int executeInfo(CommandContext<FabricClientCommandSource> context) {
        int index = IntegerArgumentType.getInteger(context, (String)"index");
        PlayerActionUtil.notifyAll(BUConfig.get().userOrders.get(index).toString());
        return 1;
    }
}

