/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.utils;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.ChestLoadedEvent;
import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.ItemInfo;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class OrderUpdater {
    private static class_1263 lowerChestInventory;
    private static final String PREFIX_BUY = "BUY";
    private static final String PREFIX_SELL = "SELL";
    private static final String LORE_FILLED = "Filled";
    private static final String LORE_PER_UNIT = "per unit";
    private static final String LORE_TO_CLAIM = "to claim!";
    private static final String LORE_ITEMS = "items";
    private static final String LORE_COINS = " coins";
    private static final String LORE_ORDER_AMOUNT = "Order amount: ";
    private static final String LORE_OFFER_AMOUNT = "Offer amount: ";
    private static final String WORD_UNIT = "unit:";
    private static final double FILL_TOLERANCE_RATIO = 0.05;

    @EventHandler(priority=100)
    public static void onGUI(ChestLoadedEvent event) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        if (!screenInfo.inMenu(ScreenInfo.BazaarMenuType.ORDER_SCREEN)) {
            return;
        }
        lowerChestInventory = event.getLowerChestInventory();
        List<class_1799> allInventoryStacks = event.getItemStacks();
        List<class_1799> orderStacks = OrderUpdater.extractOrderStacks(allInventoryStacks);
        OrderUpdater.updateWatchedOrders(orderStacks);
    }

    private static void updateWatchedOrders(List<class_1799> orderStacks) {
        List<OrderInfoContainer> parsedOrders = orderStacks.stream().map(OrderUpdater::parseOrderFromItemStack).toList();
        OrderUpdater.updateOrders(parsedOrders);
    }

    private static void updateOrders(List<OrderInfoContainer> parsedOrders) {
        ArrayList<BazaarOrder> userOrdersCopy = new ArrayList<BazaarOrder>(BUConfig.get().userOrders);
        parsedOrders.iterator().forEachRemaining(order -> {
            Optional<BazaarOrder> matchedOrder = order.findOrderInList(userOrdersCopy);
            matchedOrder.ifPresent(matched -> {
                OrderUpdater.updateBazaarOrder(matched, order.getItemInfo());
                userOrdersCopy.remove(matched);
            });
            if (matchedOrder.isEmpty()) {
                BazaarOrder newOrder = order.toBazaarOrder();
                Util.addWatchedOrder(newOrder);
                OrderUpdater.updateBazaarOrder(newOrder, order.getItemInfo());
            }
        });
        if (!userOrdersCopy.isEmpty()) {
            userOrdersCopy.forEach(BazaarOrder::removeFromWatchedItems);
        }
    }

    private static void updateBazaarOrder(BazaarOrder order, ItemInfo parsedItemInfo) {
        if (parsedItemInfo == null) {
            Util.notifyError("Error while updating order info", new Throwable("ItemInfo is null"));
            return;
        }
        order.setItemInfo(parsedItemInfo);
        Optional loreComponent = order.getItemInfo().itemStack().method_57380().method_57845(class_9334.field_49632);
        if (loreComponent == null || loreComponent.isEmpty()) {
            return;
        }
        List loreLines = ((class_9290)loreComponent.get()).comp_2401();
        int amountFilled = OrderUpdater.parseAmountFilled(loreLines);
        int amountClaimed = OrderUpdater.parseAmountClaimed(loreLines, amountFilled);
        double pricePerItem = OrderUpdater.parseUnitPrice(loreLines);
        int volume = order.getVolume();
        order.setAmountFilled(amountFilled);
        if (Util.genericIsSimilarValue(amountFilled, volume, (double)volume * 0.05)) {
            order.setFilled();
        }
        if (amountClaimed >= 0) {
            order.setAmountClaimed(amountClaimed);
        }
        order.setPricePerItem(pricePerItem);
        order.setTolerance(0.0);
    }

    private static OrderInfoContainer parseOrderFromItemStack(class_1799 stack) {
        String title = stack.method_7964().getString();
        ItemInfo itemInfo = new ItemInfo(OrderUpdater.mapScreenIndexToInventoryIndex(stack), stack);
        Optional loreComponent = stack.method_57380().method_57845(class_9334.field_49632);
        if (loreComponent == null || loreComponent.isEmpty()) {
            return null;
        }
        List loreLines = ((class_9290)loreComponent.get()).comp_2401();
        OrderType orderType = OrderUpdater.detectOrderType(title);
        if (orderType == null) {
            Util.notifyError("Error while parsing order from item stack", new Exception("Could not determine order side"));
            return null;
        }
        double unitPrice = OrderUpdater.parseUnitPrice(loreLines);
        if (Double.isNaN(unitPrice)) {
            Util.notifyError("Error while parsing order from item stack", new Exception("Missing unit price"));
            return null;
        }
        int volume = OrderUpdater.parseVolume(loreLines);
        if (volume == -1) {
            Util.notifyError("Error while parsing order from item stack", new Exception("Missing volume"));
            return null;
        }
        String cleanName = OrderUpdater.stripPrefix(title, orderType);
        PriceInfoContainer.PriceType priceType = orderType == OrderType.SELL ? PriceInfoContainer.PriceType.INSTABUY : PriceInfoContainer.PriceType.INSTASELL;
        return new OrderInfoContainer(cleanName, volume, unitPrice, priceType, itemInfo);
    }

    private static OrderType detectOrderType(String title) {
        if (title.contains(PREFIX_BUY)) {
            return OrderType.BUY;
        }
        if (title.contains(PREFIX_SELL)) {
            return OrderType.SELL;
        }
        return null;
    }

    private static String stripPrefix(String title, OrderType type) {
        String prefix = (type == OrderType.BUY ? PREFIX_BUY : PREFIX_SELL) + " ";
        return title.startsWith(prefix) ? title.substring(prefix.length()) : title;
    }

    private static double parseUnitPrice(List<class_2561> lore) {
        class_2561 line = Util.findComponentWith(lore, LORE_PER_UNIT);
        if (line == null) {
            return Double.NaN;
        }
        String raw = line.getString();
        try {
            return Double.parseDouble(Util.extractTextAfterWord(raw, WORD_UNIT));
        }
        catch (Exception ignored) {
            return Double.NaN;
        }
    }

    private static int parseVolume(List<class_2561> lore) {
        class_2561 line = Util.findComponentWith(lore, LORE_ORDER_AMOUNT);
        if (line == null) {
            line = Util.findComponentWith(lore, LORE_OFFER_AMOUNT);
        }
        if (line == null) {
            return -1;
        }
        try {
            return Util.parseNumber(((class_2561)line.method_10855().get(1)).getString());
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static int parseAmountFilled(List<class_2561> lore) {
        class_2561 filledLine = Util.findComponentWith(lore, LORE_FILLED);
        if (filledLine == null) {
            return -1;
        }
        String s = filledLine.getString();
        int slash = s.indexOf(47);
        if (slash == -1) {
            return -1;
        }
        try {
            return Util.parseNumber(s.substring(8, slash));
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static int parseAmountClaimed(List<class_2561> lore, int amountFilled) {
        if (amountFilled < 0) {
            return -1;
        }
        class_2561 unclaimedLine = Util.findComponentWith(lore, LORE_TO_CLAIM);
        if (unclaimedLine == null) {
            return amountFilled;
        }
        String raw = unclaimedLine.getString();
        int start = 9;
        int end = !raw.contains(LORE_ITEMS) ? raw.indexOf(LORE_COINS) : raw.indexOf(LORE_ITEMS) - 1;
        if (end <= start) {
            return -1;
        }
        try {
            int unclaimed = Util.parseNumber(raw.substring(start, end));
            return amountFilled - unclaimed;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static List<class_1799> extractOrderStacks(List<class_1799> screenStacks) {
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        for (class_1799 stack : screenStacks) {
            if (stack.method_31574(class_1802.field_8157)) continue;
            if (stack.method_31574(class_1802.field_8107)) break;
            result.add(stack);
        }
        return result;
    }

    private static int mapScreenIndexToInventoryIndex(class_1799 target) {
        if (lowerChestInventory == null) {
            return -1;
        }
        for (int i = 0; i < lowerChestInventory.method_5439(); ++i) {
            class_1799 current = lowerChestInventory.method_5438(i);
            if (current.method_7960() || !current.equals(target)) continue;
            return i;
        }
        return -1;
    }

    @RunOnInit
    public static void subscribe() {
        BazaarUtils.EVENT_BUS.subscribe(OrderUpdater.class);
    }

    private static enum OrderType {
        BUY,
        SELL;

    }
}

