/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.utils;

import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.data.BazaarData;
import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public class ResourceManager {
    private static final Path MOD_CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("bazaarutils");
    private static final Path LOCAL_RESOURCES_PATH = MOD_CONFIG_DIR.resolve("bazaar-resources.json");
    private static final class_2960 BUNDLED_RESOURCES_ID = class_2960.method_60655((String)"bazaarutils", (String)"bazaar-resources.json");
    private static final String GITHUB_API_URL = "https://api.github.com/repos/mkram17/Skyblock-Bazaar-Conversions/contents/conversionupdating/bazaar-conversions.json?ref=main";

    public static void initialize() {
        CompletableFuture.runAsync(() -> {
            try {
                if (!Files.exists(MOD_CONFIG_DIR, new LinkOption[0])) {
                    Files.createDirectories(MOD_CONFIG_DIR, new FileAttribute[0]);
                }
                ResourceManager.copyDefaultResourcesIfMissing();
                ResourceManager.checkForUpdates(false);
            }
            catch (IOException e) {
                Util.notifyError("Failed to initialize resource manager", e);
            }
        });
    }

    private static void copyDefaultResourcesIfMissing() throws IOException {
        if (Files.exists(LOCAL_RESOURCES_PATH, new LinkOption[0])) {
            return;
        }
        Util.logMessage("Local resources file not found. Copying from bundled resources.");
        Optional resourceOptional = class_310.method_1551().method_1478().method_14486(BUNDLED_RESOURCES_ID);
        if (resourceOptional.isPresent()) {
            try (InputStream inputStream = ((class_3298)resourceOptional.get()).method_14482();){
                Files.copy(inputStream, LOCAL_RESOURCES_PATH, new CopyOption[0]);
                BUConfig.get().resourcesSha = "";
                Util.scheduleConfigSave();
            }
        } else {
            Util.notifyError("Could not find bundled bazaar-resources.json", null);
        }
    }

    public static void checkForUpdates(boolean manual) {
        CompletableFuture.runAsync(() -> {
            try {
                URL url = new URI(GITHUB_API_URL).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
                if (connection.getResponseCode() != 200) {
                    if (manual) {
                        Util.notifyError("Failed to check for resource updates.", new Exception());
                    }
                    Util.logError("GitHub API responded with code: " + connection.getResponseCode(), null);
                    return;
                }
                try (Scanner scanner = new Scanner(connection.getInputStream());){
                    String responseBody = scanner.useDelimiter("\\A").next();
                    JsonObject jsonObject = JsonParser.parseString((String)responseBody).getAsJsonObject();
                    String latestSha = jsonObject.get("sha").getAsString();
                    String downloadUrl = jsonObject.get("download_url").getAsString();
                    if (!latestSha.equals(BUConfig.get().resourcesSha)) {
                        if (manual) {
                            PlayerActionUtil.notifyAll("New resources found, downloading...");
                        }
                        ResourceManager.downloadLatestResources(downloadUrl, latestSha);
                    } else if (manual) {
                        PlayerActionUtil.notifyAll("Resources are already up-to-date.");
                    }
                }
            }
            catch (Exception e) {
                if (manual) {
                    Util.notifyError("An error occurred while checking for updates.", new Exception());
                }
                Util.notifyError("Failed to check for resource updates", e);
            }
        });
    }

    private static void downloadLatestResources(String downloadUrl, String latestSha) {
        Path tempPath = LOCAL_RESOURCES_PATH.resolveSibling("bazaar-resources.json.tmp");
        try (InputStream in = new URI(downloadUrl).toURL().openStream();){
            Files.copy(in, tempPath, StandardCopyOption.REPLACE_EXISTING);
            Files.move(tempPath, LOCAL_RESOURCES_PATH, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            BUConfig.get().resourcesSha = latestSha;
            Util.scheduleConfigSave();
            BazaarData.setConversionsLoaded(false);
            PlayerActionUtil.notifyAll("Successfully updated Bazaar resources!");
        }
        catch (Exception e) {
            Util.notifyError("Failed to download resources", e);
            try {
                Files.deleteIfExists(tempPath);
            }
            catch (IOException ex) {
                Util.logError("Failed to delete temporary resource file", ex);
            }
        }
    }

    public static JsonObject getResourceJson() {
        try {
            String content = Files.readString(LOCAL_RESOURCES_PATH);
            return JsonParser.parseString((String)content).getAsJsonObject();
        }
        catch (IOException e) {
            block10: {
                JsonObject jsonObject;
                block11: {
                    Util.notifyError("Could not read local bazaar-resources.json", e);
                    Optional resourceOptional = class_310.method_1551().method_1478().method_14486(BUNDLED_RESOURCES_ID);
                    if (!resourceOptional.isPresent()) break block10;
                    InputStream inputStream = ((class_3298)resourceOptional.get()).method_14482();
                    try {
                        String content = new String(inputStream.readAllBytes());
                        jsonObject = JsonParser.parseString((String)content).getAsJsonObject();
                        if (inputStream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            Util.notifyError("Fallback to bundled resources also failed", ex);
                        }
                    }
                    inputStream.close();
                }
                return jsonObject;
            }
            return new JsonObject();
        }
    }

    @RunOnInit
    public static void onClientStart() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> ResourceManager.initialize());
    }
}

