package com.github.mkram17.bazaarutils.misc;

import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.events.ChestLoadedEvent;
import com.github.mkram17.bazaarutils.events.ReplaceItemEvent;
import com.github.mkram17.bazaarutils.events.SlotClickEvent;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CustomItemButton {
    //TODO make flip helper and custom order use this instead of their own settings variables when possible
    protected int slotNumber;
    @Getter @Setter
    protected transient class_1799 replacementItem;
    protected static final class_6880<class_3414> BUTTON_SOUND = class_3417.field_15015;
    protected static final float BUTTON_VOLUME = .2f;

    protected void onGuiLoad(ChestLoadedEvent event) {

    }

    protected boolean shouldReplaceItem(ReplaceItemEvent event) {
        return event.getSlotId() == slotNumber;
    }

    protected boolean shouldUseSlot(SlotClickEvent event) {
        return (event.slotId == slotNumber);
    }

    public Option<Boolean> createOption(String name, String description, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return Option.<Boolean>createBuilder()
                .name(class_2561.method_43470(name))
                .binding(true,
                        getter,
                        setter)
                .description(OptionDescription.of(class_2561.method_43470(description)))
                .controller(BUConfigGui::createBooleanController)
                .build();
    }
}
