package com.github.mkram17.bazaarutils.misc.widgets;

import com.github.mkram17.bazaarutils.mixin.AccessorHandledScreen;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_7919;
import net.minecraft.class_8666;

public class ItemSlotButtonWidget extends class_344 {
    private final class_1799 itemStack;
    public record ScreenWidgetDimensions(int x, int y, int backgroundWidth) {}

    public ItemSlotButtonWidget(int x, int y, int width, int height, class_8666 textures, class_4241 onPress, class_1799 itemStack, class_2561 tooltip) {
        super(x, y, width, height, textures, onPress, class_2561.method_43473());
        this.itemStack = itemStack;
        this.method_47400(class_7919.method_47407(tooltip));
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_48579(context, mouseX, mouseY, delta);

        if (this.itemStack != null && !this.itemStack.method_7960()) {
            int itemX = this.method_46426() + (this.field_22758 - 16) / 2;
            int itemY = this.method_46427() + (this.field_22759 - 16) / 2;

            context.method_51427(this.itemStack, itemX, itemY);
        }
    }

    public static ScreenWidgetDimensions getSafeScreenDimensions(AccessorHandledScreen screen, String screenTitle) {
        int currentX = screen.getX();
        int currentY = screen.getY();
        int currentBgWidth = screen.getBackgroundWidth();

        if (currentBgWidth <= 0) {
            PlayerActionUtil.notifyAll("BackgroundWidth is not yet initialized correctly in init TAIL for " + screenTitle, Util.notificationTypes.GUI);
        }
        return new ScreenWidgetDimensions(currentX, currentY, currentBgWidth);
    }
}