package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.misc.autoregistration.RegisterWidget;
import com.github.mkram17.bazaarutils.misc.widgets.ItemSlotButtonWidget;
import com.github.mkram17.bazaarutils.mixin.AccessorHandledScreen;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8666;
import java.util.Collections;
import java.util.List;

//brings you to the orders page as long as you have a cookie
public class BazaarOpenOrdersButton {

    @Getter @Setter
    private boolean enabled;
    private static final class_2960 BASE = class_2960.method_43902(BazaarUtils.MODID, "widget/generic_widget_base");
    private static final class_2960 HOVER = class_2960.method_43902(BazaarUtils.MODID, "widget/generic_widget_hover");
    public static final class_8666 SLOT_BUTTON_TEXTURES = new class_8666(
            BASE,
            HOVER);

    public BazaarOpenOrdersButton(boolean enabled) {
        this.enabled = enabled;
    }

    @RegisterWidget
    public static List<ItemSlotButtonWidget> getWidget() {
        if(!BUConfig.get().bazaarOpenOrdersButton.isEnabled())
            return Collections.emptyList();

        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        if (!(class_310.method_1551().field_1755 instanceof AccessorHandledScreen screen) || !screenInfo.inBazaar())
            return Collections.emptyList();


        ItemSlotButtonWidget.ScreenWidgetDimensions dimensions = ItemSlotButtonWidget.getSafeScreenDimensions(screen, screenInfo.getContainerName());

        ItemSlotButtonWidget button = getItemSlotButtonWidget(dimensions);
        return Collections.singletonList(button);
    }

    private static ItemSlotButtonWidget getItemSlotButtonWidget(ItemSlotButtonWidget.ScreenWidgetDimensions dimensions) {
        int buttonSize = 18;
        int spacing = 4;
        int buttonOffset = 18; // to avoid overlap with other buttons since this is the second button down
        int buttonX = dimensions.x() - buttonSize - spacing;
        int currentButtonY = dimensions.y() + spacing + (buttonOffset + spacing) * 1;

        return new ItemSlotButtonWidget(
                buttonX,
                currentButtonY,
                buttonSize, buttonSize,
                SLOT_BUTTON_TEXTURES,
                (btn) -> {
//                    GUIUtils.closeHandledScreen();
                    PlayerActionUtil.runCommand("managebazaarorders");
                },
                class_1802.field_8529.method_7854(),
                class_2561.method_43470("Go to Orders (Requires Cookie)")
        );
    }
}
