package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.data.BazaarData;
import com.github.mkram17.bazaarutils.events.SlotClickEvent;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import lombok.Getter;
import lombok.Setter;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PriceCharts implements ItemTooltipCallback, BUListener {
    @Getter @Setter
    private boolean showOutsideBazaar = false;

    // Cache: sanitized item name -> should show tooltip
    private static final Map<String, Boolean> SHOW_CACHE = new ConcurrentHashMap<>();

    @Override
    public void getTooltip(class_1799 stack, class_1792.class_9635 ctx, class_1836 type, List<class_2561> lines) {
        if (stack == null || stack.method_7960() || !shouldShow()) return;
        if (stack.method_7909().method_63680().getString().contains("GLASS_PANE")) return;

        String key = sanitizeName(stack.method_7964().getString());

        // Lazily populate cache if a synced/replaced stack appears later
        if (!SHOW_CACHE.computeIfAbsent(key, OrderInfoContainer::isValidName))
            return;

        class_5250 text = class_2561.method_43470("CTRL+SHIFT click for price charts & other info")
                .method_27695(class_124.field_1065, class_124.field_1067);
        class_5250 poweredBy = class_2561.method_43470("Powered by skyblock.finance")
                .method_27692(class_124.field_1080);

        lines.add(class_2561.method_43470(""));
        lines.add(text);
        lines.add(poweredBy);
    }

    @EventHandler
    private void onClick(SlotClickEvent e){
        if (!shouldShow() || e.isCancelled() || !(class_437.method_25442() && class_437.method_25441()))
            return;

        String itemName = sanitizeName(e.slot.method_7677().method_7964().getString());
        if (!SHOW_CACHE.getOrDefault(itemName, false)) return;

        String productID = BazaarData.findProductIdOptional(itemName).get(); // All cached items are safe
        String link = "https://skyblock.finance/items/" + productID;
        class_310.method_1551().method_1507(new class_407(confirmed -> {
            if (confirmed) {
                try {
                    net.minecraft.class_156.method_668().method_673(new URI(link));
                } catch (URISyntaxException ex) {
                    Util.notifyError("Failed to open skyblock.finance link.", ex);
                }
            }
            class_310.method_1551().method_1507(null);
        }, link, true));
        e.cancel();
    }

    @Override
    public void subscribe() {
        ItemTooltipCallback.EVENT.register(this);
        BazaarUtils.EVENT_BUS.subscribe(this);
        // Clear cache when (re)subscribing to avoid stale bazaar state leakage
        SHOW_CACHE.clear();
    }

    private boolean shouldShow(){
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        return (screenInfo.inBazaar() || showOutsideBazaar) && !screenInfo.inMenu(ScreenInfo.BazaarMenuType.BAZAAR_MAIN_PAGE);
    }

    private static String sanitizeName(String raw){
        int len = raw.length();
        if (len > 3 && raw.charAt(len - 2) == 'x' && Character.isDigit(raw.charAt(len - 1))) {
            int idx = raw.lastIndexOf('x');
            if (idx > 0) return raw.substring(0, idx - 1);
        }
        return raw;
    }

    public Option<Boolean> createOption() {
        return Option.<Boolean>createBuilder()
                .name(class_2561.method_43470("Show Price Charts Outside Bazaar"))
                .description(OptionDescription.of(class_2561.method_43470("Usually the option to CTRL+SHIFT click an item to see the price charts and other information on skyblock.finance is only shown inside the Bazaar while in an item view. This enables the feature outside of the Bazaar as well.")))
                .binding(false,
                        this::isShowOutsideBazaar,
                        this::setShowOutsideBazaar)
                .controller(BUConfigGui::createBooleanController)
                .build();
    }
}