package com.github.mkram17.bazaarutils.utils;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class PlayerActionUtil {
    public static void runCommand(String command){
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.field_3944.method_45730(command);
        }
    }

    static void sendPlayerMessage(class_2561 message){
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353(message, false);
        } else {
            Util.logMessage("Could not send notification because player is null. Message: " + message);
            Util.tickExecuteLater(100, () -> sendPlayerMessage(message));
        }
    }

    public static void notifyAll(class_2561 message) {
        class_5250 messageText = class_2561.method_43470("[" + BazaarUtils.MOD_NAME + "] ").method_27692(class_124.field_1065);
        messageText.method_10852(message.method_27661());

        sendPlayerMessage(messageText);
        Util.logMessage(message.getString());
    }

    public static void notifyAll(String message) {
        notifyAll(class_2561.method_43470(message).method_27692(class_124.field_1068));
    }

    //only used for developer messages and debugging. notifyAll(String/Text messsage) is used to send messages to the player
    public static void notifyAll(String message, Util.notificationTypes notificationType) {
        String callingName = Util.getCallingClassName();
        String simpleCallingName = callingName.substring(callingName.lastIndexOf(".") + 1);
        class_5250 messageText = class_2561.method_43470("(" + simpleCallingName + ") ")
                .method_27692(class_124.field_1065)
                .method_10852(class_2561.method_43470(message).method_27692(class_124.field_1077));

        if(notificationType.isEnabled() || BUConfig.get().developer.allMessages)
            notifyAll(messageText);
    }

    public static void notifyChatCommand(class_5250 message, String command){
        message.method_27694(style -> style
                                    .method_10958(new class_2558.class_10609("/" + command))
                                    .method_10949(new class_2568.class_10613(class_2561.method_43470("Run /" + command))));

        notifyAll(message);
    }
}
