/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.data;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.data.APIUtils;
import com.github.mkram17.bazaarutils.events.BazaarDataUpdateEvent;
import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.mixin.AccessorSkyBlockBazaarReply;
import com.github.mkram17.bazaarutils.utils.PlayerActionUtil;
import com.github.mkram17.bazaarutils.utils.ResourceManager;
import com.github.mkram17.bazaarutils.utils.Util;
import com.google.gson.JsonObject;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import meteordevelopment.orbit.ICancellable;
import net.hypixel.api.reply.skyblock.SkyBlockBazaarReply;

public final class BazaarData {
    private static final long BASE_INTERVAL_MS = 20000L;
    private static final long POST_OFFSET_MS = 500L;
    private static final long STALE_BACKOFF_MS = 750L;
    private static final long FAILURE_RETRY_MS = 500L;
    private static final int STALE_WARNING_THRESHOLD = 5;
    private static volatile SkyBlockBazaarReply currentReply;
    private static volatile long lastSnapshotTs;
    private static volatile long lastFetchWallClock;
    private static volatile ScheduledFuture<?> scheduledTask;
    private static final Object SCHED_LOCK;
    private static final AtomicInteger consecutiveIdenticalSnapshots;
    private static final AtomicInteger consecutiveFailures;
    private static volatile Map<String, String> nameToProductIdCache;
    private static volatile boolean conversionsLoaded;

    private BazaarData() {
    }

    @RunOnInit
    public static void init() {
        BazaarData.scheduleFetch(0L);
        PlayerActionUtil.notifyAll("BazaarData initialized (simple fixed-interval poller). Base=20000ms", Util.notificationTypes.BAZAARDATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleFetch(long delayMs) {
        Object object = SCHED_LOCK;
        synchronized (object) {
            if (scheduledTask != null && !scheduledTask.isDone()) {
                scheduledTask.cancel(false);
            }
            scheduledTask = BazaarUtils.BUExecutorService.schedule(BazaarData::fetchOnceSafely, delayMs, TimeUnit.MILLISECONDS);
        }
    }

    private static void fetchOnceSafely() {
        try {
            BazaarData.fetchOnce();
        }
        catch (Throwable t) {
            Util.notifyError("Unexpected error in BazaarData fetch loop", t);
            BazaarData.scheduleFetch(500L);
        }
    }

    private static void fetchOnce() {
        lastFetchWallClock = System.currentTimeMillis();
        APIUtils.API.getSkyBlockBazaar().whenComplete((reply, throwable) -> {
            if (throwable != null) {
                consecutiveFailures.incrementAndGet();
                PlayerActionUtil.notifyAll("Fetch failure (" + throwable.getClass().getSimpleName() + "). Retry in 500ms (failures=" + consecutiveFailures.get() + ")", Util.notificationTypes.BAZAARDATA);
                BazaarData.scheduleFetch(500L);
                return;
            }
            if (reply == null || !reply.isSuccess()) {
                consecutiveFailures.incrementAndGet();
                PlayerActionUtil.notifyAll("Null/unsuccessful reply. Retry in 500ms (failures=" + consecutiveFailures.get() + ")", Util.notificationTypes.BAZAARDATA);
                BazaarData.scheduleFetch(500L);
                return;
            }
            consecutiveFailures.set(0);
            long snapshotTs = BazaarData.extractLastUpdated(reply);
            if (snapshotTs <= 0L) {
                PlayerActionUtil.notifyAll("Invalid lastUpdated <= 0. Retry in 500ms", Util.notificationTypes.BAZAARDATA);
                BazaarData.scheduleFetch(500L);
                return;
            }
            if (snapshotTs != lastSnapshotTs) {
                long previous = lastSnapshotTs;
                lastSnapshotTs = snapshotTs;
                currentReply = reply;
                consecutiveIdenticalSnapshots.set(0);
                BazaarUtils.EVENT_BUS.post((ICancellable)new BazaarDataUpdateEvent((SkyBlockBazaarReply)reply));
                if (previous != -1L) {
                    PlayerActionUtil.notifyAll("New snapshot " + snapshotTs + " (\u0394 " + (snapshotTs - previous) + " ms). Scheduling next predicted fetch.", Util.notificationTypes.BAZAARDATA);
                } else {
                    PlayerActionUtil.notifyAll("First snapshot " + snapshotTs + " received.", Util.notificationTypes.BAZAARDATA);
                }
                BazaarData.scheduleNextFromSnapshot(snapshotTs);
            } else {
                int identical = consecutiveIdenticalSnapshots.incrementAndGet();
                PlayerActionUtil.notifyAll("Snapshot unchanged (" + snapshotTs + ") x" + identical, Util.notificationTypes.BAZAARDATA);
                if (identical == 5) {
                    PlayerActionUtil.notifyAll("WARNING: " + identical + " identical snapshots in a row. Server might be lagging or BASE_INTERVAL_MS too short.", Util.notificationTypes.BAZAARDATA);
                }
                BazaarData.scheduleNextFromSnapshot(snapshotTs);
            }
        });
    }

    private static void scheduleNextFromSnapshot(long snapshotTs) {
        long delay;
        long target;
        long now = System.currentTimeMillis();
        if (now >= (target = snapshotTs + 20000L + 500L)) {
            delay = 750L;
        } else {
            long typicalDelay = target - now;
            delay = Math.max(typicalDelay, 750L);
        }
        BazaarData.scheduleFetch(delay);
    }

    private static long extractLastUpdated(SkyBlockBazaarReply reply) {
        try {
            return ((AccessorSkyBlockBazaarReply)reply).bazaarutils$getLastUpdated();
        }
        catch (Exception e) {
            Util.notifyError("Failed to access lastUpdated (mixin+reflection failed)", e);
            return -1L;
        }
    }

    public static OptionalInt getOrderCountOptional(String productId, PriceInfoContainer.PriceType priceType, double price) {
        SkyBlockBazaarReply reply = currentReply;
        if (reply == null || productId == null || priceType == null) {
            return OptionalInt.empty();
        }
        try {
            List list;
            SkyBlockBazaarReply.Product product = reply.getProduct(productId);
            if (product == null) {
                return OptionalInt.empty();
            }
            switch (priceType) {
                default: {
                    throw new MatchException(null, null);
                }
                case INSTABUY: {
                    List list2 = product.getBuySummary();
                    break;
                }
                case INSTASELL: {
                    List list2 = list = product.getSellSummary();
                }
            }
            if (list == null) {
                return OptionalInt.empty();
            }
            for (SkyBlockBazaarReply.Product.Summary s : list) {
                if (Double.compare(s.getPricePerUnit(), price) != 0) continue;
                return OptionalInt.of((int)s.getOrders());
            }
            return OptionalInt.of(0);
        }
        catch (Exception e) {
            Util.notifyError("Error in getOrderCountOptional for productId=" + productId, e);
            return OptionalInt.empty();
        }
    }

    public static OptionalDouble findItemPriceOptional(String productId, PriceInfoContainer.PriceType priceType) {
        SkyBlockBazaarReply reply = currentReply;
        if (reply == null || productId == null || priceType == null) {
            return OptionalDouble.empty();
        }
        try {
            SkyBlockBazaarReply.Product product = reply.getProduct(productId);
            if (product == null) {
                return OptionalDouble.empty();
            }
            return switch (priceType) {
                default -> throw new MatchException(null, null);
                case PriceInfoContainer.PriceType.INSTABUY -> {
                    List buySummary = product.getBuySummary();
                    if (buySummary == null || buySummary.isEmpty()) {
                        yield OptionalDouble.of(0.0);
                    }
                    yield OptionalDouble.of(((SkyBlockBazaarReply.Product.Summary)buySummary.getFirst()).getPricePerUnit());
                }
                case PriceInfoContainer.PriceType.INSTASELL -> {
                    List sellSummary = product.getSellSummary();
                    if (sellSummary == null || sellSummary.isEmpty()) {
                        yield OptionalDouble.of(0.0);
                    }
                    yield OptionalDouble.of(((SkyBlockBazaarReply.Product.Summary)sellSummary.getFirst()).getPricePerUnit());
                }
            };
        }
        catch (Exception e) {
            Util.notifyError("Error in findItemPriceOptional for productId=" + productId, e);
            return OptionalDouble.empty();
        }
    }

    public static Optional<String> findProductIdOptional(String naturalName) {
        if (naturalName == null || naturalName.isBlank()) {
            return Optional.empty();
        }
        BazaarData.ensureConversionsLoaded();
        return Optional.ofNullable(nameToProductIdCache.get(naturalName.toLowerCase(Locale.ROOT)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureConversionsLoaded() {
        if (conversionsLoaded) {
            return;
        }
        Class<BazaarData> clazz = BazaarData.class;
        synchronized (BazaarData.class) {
            if (conversionsLoaded) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                HashMap<String, String> mutable = new HashMap<String, String>();
                JsonObject resources = ResourceManager.getResourceJson();
                JsonObject conversions = resources.getAsJsonObject();
                for (String key : conversions.keySet()) {
                    String value = conversions.get(key).getAsString();
                    if (value == null) continue;
                    mutable.put(value.toLowerCase(Locale.ROOT), key);
                }
                nameToProductIdCache = Collections.unmodifiableMap(mutable);
                conversionsLoaded = true;
                PlayerActionUtil.notifyAll("Loaded bazaarConversions cache: " + nameToProductIdCache.size() + " entries.", Util.notificationTypes.BAZAARDATA);
            }
            catch (Exception e) {
                Util.notifyError("Failed loading bazaarConversions cache", e);
                nameToProductIdCache = Map.of();
                conversionsLoaded = true;
            }
            return;
        }
    }

    @Deprecated
    public static Double findItemPrice(String productId, PriceInfoContainer.PriceType priceType) {
        return BazaarData.findItemPriceOptional(productId, priceType).orElse(-1.0);
    }

    @Deprecated
    public static String findProductId(String name) {
        return BazaarData.findProductIdOptional(name).orElse(null);
    }

    @Deprecated
    public static int getOrderCount(String productId, PriceInfoContainer.PriceType priceType, double price) {
        return BazaarData.getOrderCountOptional(productId, priceType, price).orElse(-1);
    }

    public static Optional<Duration> getCurrentSnapshotAge() {
        long ts = lastSnapshotTs;
        if (ts <= 0L) {
            return Optional.empty();
        }
        return Optional.of(Duration.ofMillis(System.currentTimeMillis() - ts));
    }

    public static Optional<Duration> getTimeSinceLastFetchAttempt() {
        long f = lastFetchWallClock;
        if (f <= 0L) {
            return Optional.empty();
        }
        return Optional.of(Duration.ofMillis(System.currentTimeMillis() - f));
    }

    @Generated
    public static SkyBlockBazaarReply getCurrentReply() {
        return currentReply;
    }

    @Generated
    public static long getLastSnapshotTs() {
        return lastSnapshotTs;
    }

    @Generated
    public static void setConversionsLoaded(boolean conversionsLoaded) {
        BazaarData.conversionsLoaded = conversionsLoaded;
    }

    static {
        lastSnapshotTs = -1L;
        lastFetchWallClock = -1L;
        SCHED_LOCK = new Object();
        consecutiveIdenticalSnapshots = new AtomicInteger(0);
        consecutiveFailures = new AtomicInteger(0);
        nameToProductIdCache = Map.of();
        conversionsLoaded = false;
    }
}

