/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.events.ReplaceItemEvent;
import com.github.mkram17.bazaarutils.events.SignOpenEvent;
import com.github.mkram17.bazaarutils.events.SlotClickEvent;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.misc.CustomItemButton;
import com.github.mkram17.bazaarutils.utils.GUIUtils;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.SoundUtil;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_9334;

public class CustomOrder
extends CustomItemButton
implements BUListener {
    public static final Map<Integer, class_1792> COLORMAP = new HashMap<Integer, class_1792>(Map.of(0, class_1802.field_8739, 1, class_1802.field_8747, 2, class_1802.field_8761, 3, class_1802.field_8157, 4, class_1802.field_8157));
    private boolean buySignClicked = false;
    private boolean enabled;
    private int orderAmount;
    private class_1792 item;

    public CustomOrder(boolean enabled, int orderAmount, int slotNumber, class_1792 item) {
        this.enabled = enabled;
        this.orderAmount = orderAmount;
        this.slotNumber = slotNumber;
        this.item = item;
        BazaarUtils.EVENT_BUS.subscribe((Object)this);
    }

    protected CustomOrder(boolean enabled) {
        this.enabled = enabled;
        this.orderAmount = 71680;
        this.slotNumber = 17;
        this.item = class_1802.field_8739;
    }

    public static class_1792 getNextColoredPane() {
        int size = BUConfig.get().customOrders.size();
        return COLORMAP.get(size % 5);
    }

    public static ConfigCategory.Builder createOrdersCategory() {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Buy Amount Options"));
    }

    @EventHandler
    public void replaceItemEvent(ReplaceItemEvent event) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        if (!screenInfo.inMenu(ScreenInfo.BazaarMenuType.BUY_ORDER, ScreenInfo.BazaarMenuType.INSTA_BUY) || !this.isEnabled()) {
            return;
        }
        if (event.getSlotId() != this.slotNumber) {
            return;
        }
        class_1799 itemStack = new class_1799((class_1935)this.getItem(), 1);
        itemStack.method_57379(BazaarUtils.CUSTOM_SIZE_COMPONENT, (Object)String.valueOf(this.getOrderAmount()));
        itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Buy " + this.getOrderAmount())).method_27692(class_124.field_1064));
        event.setReplacement(itemStack);
    }

    @EventHandler
    public void onSlotClicked(SlotClickEvent event) {
        ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
        if (!screenInfo.inMenu(ScreenInfo.BazaarMenuType.BUY_ORDER, ScreenInfo.BazaarMenuType.INSTA_BUY) || !this.isEnabled()) {
            return;
        }
        if (event.slot.method_34266() != this.slotNumber) {
            return;
        }
        SoundUtil.playSound((class_6880<class_3414>)BUTTON_SOUND, 0.2f);
        this.openSign();
    }

    @EventHandler
    private void onSignOpened(SignOpenEvent event) {
        if (!this.buySignClicked) {
            return;
        }
        GUIUtils.setSignText(Integer.toString(this.getOrderAmount()), true);
        this.buySignClicked = false;
    }

    public void openSign() {
        int signSlotId = 16;
        GUIUtils.clickSlot(signSlotId, 0);
        this.buySignClicked = true;
    }

    public Option<Boolean> createOption() {
        return super.createOption("Buy " + this.getOrderAmount() + " Button", "Buy order button for " + this.getOrderAmount() + " of an item.", this::isEnabled, this::setEnabled);
    }

    public static void buildOptions(OptionGroup.Builder builder) {
        ArrayList<CustomOrder> customOrders = BUConfig.get().customOrders;
        if (customOrders.isEmpty()) {
            customOrders.add(new CustomOrder(true, 71680, 17, COLORMAP.get(0)));
        }
        for (CustomOrder order : customOrders) {
            builder.option(order.createOption());
        }
    }

    public void remove() {
        if (BUConfig.get().customOrders.contains(this)) {
            BUConfig.get().customOrders.remove(this);
            Util.scheduleConfigSave();
            BazaarUtils.EVENT_BUS.unsubscribe((Object)this);
        }
    }

    @Override
    public void subscribe() {
        BazaarUtils.EVENT_BUS.subscribe((Object)this);
    }

    @Generated
    public CustomOrder() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public int getOrderAmount() {
        return this.orderAmount;
    }

    @Generated
    public void setOrderAmount(int orderAmount) {
        this.orderAmount = orderAmount;
    }

    @Generated
    public class_1792 getItem() {
        return this.item;
    }
}

